/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef DISPLAYBUF_H
#define DISPLAYBUF_H

//
// The DisplayBuffer class is the memory representation of the Tn5250 display.
// We only rely on the Terminal-derived classes to render DisplayBuffers.
//
class DisplayBuffer {
public:
   class Row {
      friend class DisplayBuffer;
   protected:
      int w;
      unsigned char *data;

      void range_check (int pos) const;

   public:
      Row ();
      ~Row ();

      int width (void) const;
      int width (int newwid);

      unsigned char at (int pos) const;
      unsigned char& at (int pos);

      Row& operator = (const Row& rhs);
      
      inline unsigned char operator [] (int pos) const
      {
	 return at (pos);
      }

      inline unsigned char& operator [] (int pos)
      {
	 return at (pos);
      }
   };

   enum {
      IND_INHIBIT	   = 0x0001,
      IND_MESSAGE_WAITING  = 0x0002,
      IND_X_SYSTEM	   = 0x0004,
      IND_X_CLOCK	   = 0x0008,
      IND_INSERT	   = 0x0010
   };

protected:
   int w, h;
   int cx, cy; /* Cursor Position */
   int tcx, tcy; /* for set_new_ic */
   Row *rows;
   int disp_indicators;

   void range_check (int pos) const;

public:
   DisplayBuffer (int wd, int ht);	
   DisplayBuffer (const DisplayBuffer& rhs);
   ~DisplayBuffer ();

   DisplayBuffer& operator = (const DisplayBuffer& rhs);

   int width (void) const;
   int height (void) const;
   int cursor_x (void) const;
   int cursor_y (void) const;
   int cursor_x (int nx);
   int cursor_y (int ny);
   void cursor (int ny, int nx);

   void _rename_me_clear (void); /* Conflict with curses macro */
   void right (int n = 1);
   void left (void);
   void up (void);
   void down (void);
   void gotoIC(void);

   void add (unsigned char c);
   void add (int y, int x, const unsigned char *data, int l);

   void del (int shiftcount);
   void ins (unsigned char c, int shiftcount);
   void set_new_ic (void);
   void set_temp_ic (int y, int x);
   void roll (int top, int bot, int lines);

   void set_indicator (int inds);
   void clear_indicator (int inds);
   int indicators (void) const;
   int indicators (int newindicators);

   int save (void);
   void restore (int n);
 
   const Row& at (int pos) const;
   Row& at (int pos);

   inline const Row& operator [] (int pos) const
   {
	 return at (pos);
   }

   inline Row& operator [] (int pos)
   {
	 return at (pos);
   }
};

#endif /* DISPLAYBUF_H */
