/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef FORMATTABLE
#define FORMATTABLE

#include <string.h>
#include <stdio.h>
#include "bufferpool.h"

/* Field Formats (Byte one) */
#define BYPASS		0x20
#define DUP_ENABLE	0x10
#define MODIFIED	0x08
#define ALPHA_SHIFT	0x00 /* 000 */
#define ALPHA_ONLY	0x01 /* 100 */
#define NUM_SHIFT	0x02 /* 010 */
#define NUM_ONLY	0x03 /* 011 */
#define KATA_SHIFT	0x04 /* 001 */
#define DIGIT_ONLY	0x05 /* 101 */
#define MAG_READER	0x06 /* 110 */
#define SIGNED_NUM	0x07 /* 111 */
#define FIELD_MASK	0x07 /* 111 */

/* Field Formats (Byte two) */
#define AUTO_ENTER	0x80
#define FER		0x40
#define MONOCASE	0x20
#define RESERVED	0x01
#define MANDATORY	0x08
#define NO_ADJUST	0x00
#define MF_RESERVED_1	0x01
#define MF_RESERVED_2	0x02
#define MF_RESERVED_3	0x03
#define MF_RESERVED_4	0x04
#define RIGHT_ZERO	0x05
#define RIGHT_BLANK	0x06
#define MANDATORY_FILL	0x07
#define MAND_FILL_MASK	0x07

#define FORMAT_TABLE_SIZE 255

struct format_field {
   unsigned char FFW[2];
   unsigned char FCW[2];
   unsigned char attribute;
   unsigned char * data;
   int start_row;
   int start_col;
   int end_row;
   int end_col;
   int start_pos;
   int end_pos;
   int length;
   int numrows;
   int MDT;
};

struct SaveBuffer {
   int numfields;
   format_field fields[FORMAT_TABLE_SIZE];
   unsigned char screen_map[80][25];
};

class FormatTable {

private:
   unsigned char screen_map[80][25];
   format_field fields[FORMAT_TABLE_SIZE];
   int old_numfields;
   int numfields;
   int MasterMDT;
   BufferPool formatbuffer;
   SaveBuffer savebuffer;      
   int message_line;
   int curfield;
        
public:
   FormatTable ();
   ~FormatTable ();
   void AddField(unsigned char FFW1, unsigned char FFW2,
        unsigned char FCW1, unsigned char FCW2, unsigned char Attr, 
        unsigned char Length1, unsigned char Length2,
        unsigned char StartRow, unsigned char StartCol);
   int NumFields();
   int CurField();
   int FirstField();
   int NextField (void);
   int NextField (int x, int y);
   int PrevField (void);
   int PrevField (int x, int y);
   void SetCurField(int FieldNumber);
   int FieldNum(int X, int Y);
   int IsBypass(int FieldNumber);
   int IsDupEnable(int FieldNumber);
   int IsFieldModified(int FieldNumber);
   int IsAlphaShift(int FieldNumber);
   int IsAlphaOnly(int FieldNumber);
   int IsNumShift(int FieldNumber);
   int IsNumOnly(int FieldNumber);
   int IsKataShift(int FieldNumber);
   int IsDigitOnly(int FieldNumber);
   int IsMagReader(int FieldNumber);
   int IsSignedNum(int FieldNumber);
   unsigned char FieldType(int FieldNumber);
   char * FieldDescription(int FieldNumber);
   int IsAutoEnter(int FieldNumber);
   int IsFer(int FieldNumber);
   int IsMonocase(int FieldNumber);
   int IsReserved(int FieldNumber);
   int IsMandatory(int FieldNumber);
   int IsNoAdjust(int FieldNumber);
   int IsMF_1(int FieldNumber);
   int IsMF_2(int FieldNumber);
   int IsMF_3(int FieldNumber);
   int IsMF_4(int FieldNumber);
   int IsRightZero(int FieldNumber);
   int IsRightBlank(int FieldNumber);
   int IsMandatoryFill(int FieldNumber);
   unsigned char AdjustFill(int FieldNumber);
   char * AdjustDescription(int FieldNumber);
   int IsModified(int FieldNumber);
   void ClearModified(int FieldNumber);
   int Attribute(int FieldNumber);
   int StartRow(int FieldNumber);
   int StartCol(int FieldNumber);
   int EndRow(int FieldNumber);
   int EndCol(int FieldNumber);
   int NumRows(int FieldNumber);
   int Length(int FieldNumber);
   int IsFull(int FieldNumber);
   void SetMDT();
   void ClearMDT();
   int IsMDTSet();
   int Save();
   void Restore(int numtable);
   void Clear();
   int CountLeft(int FieldNumber, int X, int Y);
   int CountRight(int FieldNumber, int X, int Y);
   int CountEOF(int FieldNumber);
   void PutChar(int X, int Y, unsigned char Data);
   void AddChar(int X, int Y, unsigned char Data);
   void InsChar(int X, int Y, unsigned char Data);
   void DelChar(int X, int Y);
   void FieldChar(int FieldNumber, int Position, unsigned char Data);
   unsigned char GetChar(int FieldNumber, int Position);
   void SetTraceFile(FILE * tracelog);
   void DumpMap();
   void DumpField(int number);
   void SetMessageLine(int row);
   int  GetMessageLine();
   int  FieldExit(DisplayBuffer& disp_buf, int X, int Y);
   void ClearFieldBufferToEOF (int pos, unsigned char fill_char);
   void ClearScreenToEOF(DisplayBuffer& disp_buf, int rightcount);
   void ProcessAdjust (DisplayBuffer& disp_buf, int X, int Y);
   void ShiftRightFill (int leftcount, unsigned char fill_char);
   void SetMinusZoneScreen(DisplayBuffer& disp_buf, int curfld);

};

#endif
