/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997-1999 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include "scs.h"
#include "utility.h"

void sic();
void sil();
void sls();
void process34();
void process2b();
void rff();
void noop();
void transparent();
void processd2();
void process03();
void scs();
void ssld();
void process04();
void processd1();
void process06();
void process07();
void processd103();
void stab();
void jtf();
void sjm();
void spps();
void ppm();
void svm();
void spsu();
void sea();
void shm();
void sgea();
void cr();
void nl();
void rnl();
void ht();
void ahpp();
void avpp();
void processd3();
void sto();
void ff();

unsigned char curchar;
unsigned char nextchar;
int current_line;
int new_line;
int mpp;
int ccp;

int main()
{
   int bytecount;
   int loop;

   settransmap("en");   
   current_line = 1;
   new_line = 1;
   mpp = 132;
   ccp = 1;

   while(!feof(stdin)) 
   {
      curchar = fgetc(stdin);
      switch(curchar) {
         case TRANSPARENT : {
            transparent();
            break;
         }
         case RFF : {
            rff();
            break;
         }
         case NOOP : {
            noop();
            break;
         }
         case CR : {
            cr();
            break;
         }
         case FF : {
            ff();
            break;
         }
         case NL : {
            nl();
            break;
         }
         case RNL : {
            rnl();
            break;
         }
         case HT : {
            ht();
            break;
         }
	 case 0x34 : {
            process34();
            break;
         }
         case 0x2B : {
            process2b();
            break;
         }
         case 0xFF : {
            /* This is a hack */
            /* Don't know where the 0xFF is coming from */
            break;
         }
         default : {
            if(new_line) {
               new_line = 0;
            }
            printf("%c", ebcdic2ascii(curchar));
            ccp++;
            fprintf(stderr, ">%x\n", curchar);
         }
      }
         
   }
   return(0);
}

void ht()
{
   fprintf(stderr, "HT\n");
}

void rnl()
{
   fprintf(stderr, "RNL\n");
}

void nl()
{
   if(!new_line) {
   }
   printf("\n");
   new_line = 1;
   ccp = 1;
   fprintf(stderr, "NL\n");
}

void ff()
{
   printf("\f");
   fprintf(stderr, "FF\n");
}

void cr()
{
   fprintf(stderr, "CR\n");
}

void transparent()
{

int bytecount;
int loop;

   bytecount = fgetc(stdin);
   fprintf(stderr, "TRANSPARENT (%x) = ", bytecount);
   for(loop = 0; loop < bytecount; loop++)   
   {
      printf("%c", fgetc(stdin));
   }
}

void rff()
{    
   fprintf(stderr, "RFF\n");
}

void noop()
{
   fprintf(stderr, "NOOP\n");
}

void process34()
{

   curchar = fgetc(stdin);
   switch(curchar)
   {
      case AVPP : {
         avpp();
         break;
      }
      case AHPP : {
         ahpp();
         break;
      }
      default : {
         fprintf(stderr, "ERROR: Unknown 0x34 command %x\n", curchar);
      }
   }
}

void avpp()
{
   fprintf(stderr, "AVPP %d\n", fgetc(stdin));
}

void ahpp()
{
int position;
int loop;
  
   position = fgetc(stdin);   
   if(ccp > position) {
      printf("\r");
      for(loop=0; loop < position; loop++) {
         printf(" ");
      }      
   } 
   else {
      for(loop=0; loop < position-ccp; loop++) {
         printf(" ");
      }
   }
   fprintf(stderr, "AHPP %d\n", position);
}

void process2b()
{

   curchar = fgetc(stdin);
   switch(curchar) {
      case 0xD1 : {
         processd1();
         break;
      }
      case 0xD2 : {
         processd2();
         break;
      }
      case 0xD3 : {
         processd3();
         break;
      }
      case 0xC8 : {
         sgea();
         break;
      }
      default : {
         fprintf(stderr, "ERROR: Unknown 0x2B command %x\n", curchar);
      }                  
   }
}

void processd3()
{
   curchar = fgetc(stdin);
   nextchar = fgetc(stdin);

   if(nextchar == 0xF6) {
      sto();
   }
   else {
      fprintf(stderr, "ERROR: Unknown 0x2BD3 %x %x", curchar, nextchar);
   }
}

void sto()
{
int loop;

   fprintf(stderr, "STO = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);   
   }
   fprintf(stderr, "\n");
}

void sgea()
{
   fprintf(stderr, "SGEA = %x %x %x\n", fgetc(stdin), fgetc(stdin), fgetc(stdin));
}

void processd1()
{
   curchar = fgetc(stdin);
   switch(curchar) {
      case 0x06 : {
         process06();
         break;
      }
      case 0x07 : {
         process07();
         break;
      }
      case 0x03 : {
         processd103();
         break;
      }
      default : {
         fprintf(stderr, "ERROR: Unknown 0x2BD1 command %x\n", curchar);
      }     
   }
}

void process06()
{
   curchar = fgetc(stdin);
   if(curchar == 0x01) {
      fprintf(stderr, "GCGID = %x %x %x %x\n", fgetc(stdin), fgetc(stdin),
                                      fgetc(stdin), fgetc(stdin));
   }
   else {
      fprintf(stderr, "ERROR: Unknown 0x2BD106 command %x\n", curchar);
   } 
}

void process07()
{
   curchar = fgetc(stdin);
   if(curchar == 0x05) {
      fprintf(stderr, "FID = %x %x %x %x %x\n", fgetc(stdin), fgetc(stdin),
              fgetc(stdin), fgetc(stdin), fgetc(stdin));
   }
   else {
      fprintf(stderr, "ERROR: Unknown 0x2BD107 command %x\n", curchar);
   }      
}

void processd103()
{
   curchar = fgetc(stdin);
   if(curchar = 0x81) {
      fprintf(stderr, "SCGL = %x\n", fgetc(stdin));
   }
   else {
      fprintf(stderr, "ERROR: Unknown 0x2BD103 command %x\n", curchar);
   }  
}

void processd2()
{
   curchar = fgetc(stdin);
   nextchar = fgetc(stdin);

   
   switch(nextchar) {
      case 0x01 : {
         stab();
         break;
      }
      case 0x03 : {
         jtf();
         break;
      }
      case 0x0D : {
         sjm();
         break;
      }
      case 0x40 : {
         spps();
         break;
      }
      case 0x48 : {
         ppm();
         break;
      }
      case 0x49 : {
         svm();
         break;
      }
      case 0x4c : {
         spsu();
         break;
      }
      case 0x85 : {
         sea();
         break;
      }
      case 0x11 : {
         shm();
         break;
      }
      default : {
         switch(curchar) {
            case 0x03 : {
               process03();
               break;
            }
            case 0x04 : {
               process04(); 
               break;
            }
            default : {
               fprintf(stderr, "ERROR: Unknown 0x2BD2 command %x\n", curchar);
            }
         }
      }
   }

}

void stab()
{
int loop;

   fprintf(stderr, "STAB = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void jtf()
{
int loop;

   fprintf(stderr, "JTF = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void sjm()
{
int loop;

   fprintf(stderr, "SJM = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void spps()
{
int loop;
int width;
int length;

   fprintf(stderr, "SPPS = ");

   width = fgetc(stdin);
   width = width << 8 + fgetc(stdin);

   length = fgetc(stdin);
   length = length << 8 + fgetc(stdin);
   
   fprintf(stderr, "SPPS (width = %d) (length = %d)\n", width, length);

}

void ppm()
{
int loop;

   fprintf(stderr, "PPM = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}


void svm()
{
int loop;

   fprintf(stderr, "SVM = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void spsu()
{
int loop;

   fprintf(stderr, "SPSU (%x) = ", curchar);
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void sea()
{
int loop;

   fprintf(stderr, "SEA (%x) = ", curchar);
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void shm()
{
int loop;

   fprintf(stderr, "SHM = ");
   for(loop = 0; loop < curchar-2; loop++)
   {
      nextchar = fgetc(stdin);
      fprintf(stderr, " %x", nextchar);
   }   
   fprintf(stderr, "\n");
}

void process03()
{
   switch(nextchar) {
      case 0x45 : {
         sic();
         break;
      }
      case 0x07 : {
         sil();
         break;
      }
      case 0x09 : {
         sls();
         break;
      }
      default : {
         fprintf(stderr, "ERROR: Unknown 0x2BD203 command %x\n", curchar);
      }
   }
}

void sic()
{
   curchar = fgetc(stdin);
   fprintf(stderr, "SIC = %x\n", curchar);
}

void sil()
{
   curchar = fgetc(stdin);
   fprintf(stderr, "SIL = %d", curchar);
}

void sls()
{
   curchar = fgetc(stdin);
   fprintf(stderr, "SLS = %d\n", curchar);
}

void process04()
{
   switch(nextchar) {
      case 0x15 : {
         ssld();
         break;
      }
      case 0x29 : {
         scs();
         break;
      }
      default : {
         fprintf(stderr, "ERROR: Unknown 0x2BD204 command %x\n", curchar);
      }
   }
}

void ssld()
{
   curchar = fgetc(stdin);
   nextchar = fgetc(stdin);
   fprintf(stderr, "SSLD = %d %d \n", curchar, nextchar);
}

void scs()
{
   curchar = fgetc(stdin);
   if(curchar == 0x00) {
      curchar = fgetc(stdin);
      fprintf(stderr, "SCS = %d", curchar);
   }
   else {
      fprintf(stderr, "ERROR: Unknown 0x2BD20429 command %x\n", curchar);
   }
}