/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef STREAM5250
#define STREAM5250

#include <stdio.h>
#include <string.h>
#include "record.h"

#define SEND    1
#define IS      0 
#define INFO    2
#define VALUE   1
#define VAR     0
#define VALUE   1
#define USERVAR 3

#define TERMINAL 1
#define BINARY   2
#define RECORD   4
#define DONE     7

#define TRANSMIT_BINARY 0
#define END_OF_RECORD   25
#define TERMINAL_TYPE   24
#define TIMING_MARK     6
#define NEW_ENVIRON	39

#define EOR  239
#define SE   240   
#define SB   250
#define WILL 251
#define WONT 252
#define DO   253
#define DONT 254 
#define IAC  255


struct header {
   int length;
   unsigned char flags;
   unsigned char opcode;
};

class Stream5250 {
private:

   class Packet : public Buffer {
   public:
      Buffer data;
      Packet *next;
      Packet *prev;
   };

   enum {
      STATE_NO_DATA,	   /* dummy state */
      STATE_DATA,
      STATE_HAVE_IAC,
      STATE_HAVE_VERB,	   /* eg DO, DONT, WILL, WONT */
      STATE_HAVE_SB,	   /* SB data */
      STATE_HAVE_SB_IAC
   } state;

   Packet *packets;
   Packet *current_packet;
   int packet_count;

   SOCKET_TYPE sockfd;
   int status;
   char * termtype;
   char devicename[10];
   char transformname[10];

   int getnext();
   void badstate(int location);   
   void sb (unsigned char *sb_buf, int sb_len);
   void do_verb (unsigned char verb, unsigned char what);

   static Buffer TelnetEscape (Buffer in);
         
public:
   Stream5250 ();
   ~Stream5250 ();

   void SetTerminalType (const char * str);
   int Connect(char * address, char * port, char * sessionname,
               char * transform);
   void Disconnect();
   int GetByte();
   void Write(unsigned char * data, int size);
   void SendPacket(int length, int flowtype, unsigned char flags, unsigned char opcode, unsigned char * data);
   void GetPacket(Record * Packet);
   void QueryReply();
   void PrintComplete();
   SOCKET_TYPE GetSocketHandle();

   bool HandleReceive ();
   int GetPacketCount ();
};
#endif
