/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "utility.h"

unsigned char* ebcdicmap = NULL;
unsigned char* asciimap = NULL;

struct transmap {
  char* mapname;
  unsigned char const* ebcdicmap;
  unsigned char const* asciimap;
};

#include "transmaps.h"

unsigned char ascii2ebcdic(unsigned char ascii)
{
   return(asciimap[ascii]);
}

unsigned char ebcdic2ascii(unsigned char ebcidic)
{
   if(ebcidic == 0x1C)
      return('*');
   else
      return(ebcdicmap[ebcidic]);
}

void settransmap(char* map)
{
   transmap* t;
   for (t = transmaps; t->mapname; t++) {
     if (strcmp(t->mapname, map) == 0) {
       asciimap = new unsigned char[256];
       ebcdicmap = new unsigned char[256];
       memcpy(ebcdicmap,t->ebcdicmap,256);
       memcpy(asciimap,t->asciimap,256);
       break;
     }
   }
   if (!t->mapname) {
     printf("Invalid mapname: %s\n"
	    "Try one out of:\n ", map);
     for (t = transmaps; t->mapname; t++) {
       printf("%s ", t->mapname);
     }
     printf("\n");
     exit(1);
   }
   ebcdicmap[0] = ' ';
}

int Printable(unsigned char data)
{
   int printable;

   if(data == 0x00)
      printable = 1;
   else if( (data > 0x1C) && (data < 0xFF) )
      printable = 1;
   else
      printable = 0;

   return(printable);

}

int Attribute(unsigned char data)
{
   return( (data & 0xE0) == 0x20 );
}

int isnumeric(char data)
{
   char list[] = "0123456789 +-,.";
   int rc;

   rc = 0;
   if(strchr(list, data))
      rc = 1;

   return(rc);
   
}

#ifndef NDEBUG
static FILE * logfile = NULL;

void log_open (const char *fname)
{
	if (logfile != NULL)
		fclose (logfile);
	logfile = fopen (fname, "w");
	if (logfile == NULL) {
		perror (fname);
		exit (1);
	}
#ifndef WIN32
	// Set file mode to 0600 since it may contain passwords.
	fchmod (fileno (logfile), 0600);
#endif
        setbuf (logfile, NULL);
}

void log_close ()
{
        if (logfile != NULL) {
                fclose (logfile);
                logfile = NULL;
        }

}

void log_printf (const char *fmt, ...)
{
	va_list vl;
	if (logfile != NULL) {
		va_start (vl, fmt);
		vfprintf (logfile, fmt, vl);
		va_end (vl);
	}
}
#endif /* NDEBUG */
