/****************************************************************************/
/*                                                                          */
/*                            Sign a Data File                              */
/*                                                                          */
/*  This file is copyright 2003 IBM. See "License" for details              */
/****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <openssl/sha.h>
#include <tcpa.h>

int main(int argc, char *argv[])
{
    uint32_t ret;
    unsigned char databuff[65535];      /* data read work buffer */
    uint32_t parhandle;         /* handle of parent key */
    unsigned char passhash[20]; /* hash of parent key password */
    unsigned char datahash[20]; /* hash of data file */
    unsigned char sig[4096];    /* resulting signature */
    unsigned int siglen;        /* signature length */
    SHA_CTX sha;
    FILE *infile;
    FILE *sigfile;

    if (argc < 5) {
        fprintf(stderr, "Usage: signfile <key handle in hex> <key password> <input file> <outputfile>\n");
        exit(1);
    }
    ret = sscanf(argv[1], "%x", &parhandle);
    if (ret != 1) {
        fprintf(stderr, "Invalid argument '%s'\n", argv[1]);
        exit(2);
    }
    sha1(argv[2], strlen(argv[2]), passhash);
    infile = fopen(argv[3], "r");
    if (infile == NULL) {
        fprintf(stderr, "Unable to open input file '%s'\n", argv[3]);
        exit(2);
    }
    SHA1_Init(&sha);
    for (;;) {
        ret = fread(databuff, 1, sizeof databuff, infile);
        if (ret < 0) {
            fprintf(stderr, "I/O Error while reading input file '%s'\n",
                    argv[3]);
            exit(3);
        }
        SHA1_Update(&sha, databuff, ret);
        if (ret < sizeof databuff)
            break;
    }
    fclose(infile);
    SHA1_Final(datahash, &sha);
    ret = TPM_Sign(parhandle,   /* Key Handle */
                   passhash,    /* key Password */
                   datahash, sizeof(datahash),  /* data to be signed, length */
                   sig, &siglen,       /* buffer to receive sig, length */
		   TPMLOG);
    if (ret != 0) {
        printf("Error %d from TPM_Sign\n", ret);
        exit(1);
    }
    sigfile = fopen(argv[4], "w");
    if (sigfile == NULL) {
        fprintf(stderr, "Unable to open output file '%s'\n", argv[4]);
        exit(4);
    }
    ret = fwrite(sig, 1, siglen, sigfile);
    if (ret != siglen) {
        fprintf(stderr, "I/O Error while writing output file '%s'\n",
                argv[4]);
        exit(5);
    }
    fclose(sigfile);
    exit(0);
}
