/****************************************************************************/
/*                                                                          */
/*                      Test of TCPA Take Ownership                         */
/*                                                                          */
/*  This file is copyright 2003 IBM. See "License" for details              */
/****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include <openssl/evp.h>
#include <tcpa.h>

int main(int argc, char *argv[])
{
    uint32_t ret;
    unsigned char pass1hash[20];
    unsigned char pass2hash[20];
    keydata srk;
    RSA *rsa;                   /* OpenSSL format Public Key */
    FILE *keyfile;              /* output file for public key */
    EVP_PKEY pkey;              /* OpenSSL public key */

    if (argc < 3) {
        fprintf(stderr, "Usage: takeown <ownerpass> <SRK password>\n");
        exit(1);
    }
    sha1(argv[1], strlen(argv[1]), pass1hash);
    sha1(argv[2], strlen(argv[2]), pass2hash);
    ret = TPM_TakeOwnership(pass1hash, pass2hash, &srk, TPMLOG);
    if (ret != 0) {
        fprintf(stderr, "Error %d from TPM_TakeOwnership\n", ret);
        exit(2);
    }
    /*
     ** convert the returned public key to OpenSSL format and
     ** export it to a file
     */
    rsa = convpubkey(&(srk.pub));
    if (rsa == NULL) {
        fprintf(stderr, "Error from TSS_convpubkey\n");
        exit(3);
    }
    OpenSSL_add_all_algorithms();
    EVP_PKEY_assign_RSA(&pkey, rsa);
    keyfile = fopen("srootkey.pem", "w");
    if (keyfile == NULL) {
        fprintf(stderr, "Unable to create public key file\n");
        exit(4);
    }
    ret = PEM_write_PUBKEY(keyfile, &pkey);
    if (ret == 0) {
        fprintf(stderr, "Unable to write public key file\n");
        exit(5);
    }
    fclose(keyfile);
    RSA_free(rsa);
    exit(0);
}
