/****************************************************************************/
/*                                                                          */
/*  TCPA.H  03 Apr 2003                                                     */
/*                                                                          */
/* This file is copyright 2003 IBM. See "License" for details               */
/****************************************************************************/
#ifndef TCPA_H
#define TCPA_H

#include <stdio.h>
#include <stdint.h>
#include <tpm.h>
#include <keys.h>
#include <oiaposap.h>
#include <pcrs.h>
#include <hmac.h>

uint32_t TPM_Transmit(unsigned char *buff, FILE *log, char *msg);
uint32_t TPM_Reset(FILE *log);
uint32_t TPM_GetCapability_Version(int *major, int *minor, int *version,
                                   int *rev, FILE *log);
uint32_t TPM_GetCapability_Slots(uint32_t *slots, FILE *log);
uint32_t TPM_GetCapability_Pcrs(uint32_t *pcrs, FILE *log);
uint32_t TPM_GetCapability_Key_Handle(uint16_t *num, uint32_t keys[],FILE *log);
uint32_t TPM_ReadPubek(pubkeydata *k, FILE *log);
uint32_t TPM_OIAP(uint32_t *handle, char *enonce, FILE *log);
uint32_t TPM_OSAP(osapsess *sess, unsigned char *key, uint16_t etype,
                  uint32_t evalue, FILE *log);
uint32_t TPM_Terminate_Handle(uint32_t handle, FILE *log);
uint32_t TPM_TakeOwnership(unsigned char *ownpass, unsigned char *srkpass,
                           keydata *key, FILE *log);
uint32_t TPM_CreateWrapKey(uint32_t keyhandle,
                           unsigned char *keyauth,
                           unsigned char *newauth,
                           unsigned char *migauth,
                           keydata *keyparms, keydata *key, FILE *log);
uint32_t TPM_LoadKey(uint32_t keyhandle, unsigned char *keyauth,
                     keydata *keyparms, uint32_t *newhandle, FILE *log);
uint32_t TPM_EvictKey(uint32_t keyhandle, FILE *log);
uint32_t TPM_Sign(uint32_t keyhandle, unsigned char *keyauth,
                  unsigned char *data, int datalen,
                  unsigned char *sig, unsigned int *siglen, FILE *log);
uint32_t TPM_Seal(uint32_t keyhandle,
                  unsigned char *pcrinfo, uint32_t pcrinfosize,
                  unsigned char *keyauth,
                  unsigned char *dataauth,
                  unsigned char *data, unsigned int datalen,
                  unsigned char *blob, unsigned int *bloblen, FILE *log);
uint32_t TPM_Seal_CurrPCR(uint32_t keyhandle,
                          uint32_t pcrmap,
                          unsigned char *keyauth,
                          unsigned char *dataauth,
                          unsigned char *data, unsigned int datalen,
                          unsigned char *blob, unsigned int *bloblen,
                          FILE *log);
uint32_t TPM_Unseal(uint32_t keyhandle,
                  unsigned char *keyauth,
                  unsigned char *dataauth,
                  unsigned char *blob, unsigned int bloblen, 
                  unsigned char *data, unsigned int *datalen, FILE *log);
uint32_t TPM_PcrRead(uint32_t pcrindex, unsigned char *pcrvalue,
                     FILE *log);
#endif
