/* pcux/audio.c 
	vi:ts=3 sw=3:
 */
/* minor mods for pl14 by Mike Battersby */
/* Modified from soundblaster_audio.c by Hannu Savolainen */
/* hsavolai@cs.helsinki.fi */

#include "defs.h"
#include <unistd.h>
#include <fcntl.h>
#include "extern.h"

struct options_set *port_options=0;

#define DEFAULT_BUFFERS
#define UNSIGNED8
#define DEFAULT_SET_MIX
#define NEW_OUTPUT_SAMPLES_AWARE

#include "Arch/common.c"


#ifdef PL_14
/* For some reason my pl14 kernel had no sys/soundcard.h (???) */
#include "/usr/src/linux/drivers/sound/soundcard.h"
#else
#ifndef __FreeBSD__
/*	This should be sys/soundcard.h	*/
#include <sys/soundcard.h>
#else
#include <machine/soundcard.h>
#endif
#endif




ID("$Id: audio.c,v 5.1 1996/04/12 16:30:31 espie Exp espie $")

LOCAL unsigned long samples_max;
LOCAL int audio;           	/* /dev/dsp */
LOCAL unsigned long current_freq;

unsigned long total;

LOCAL int dsp_samplesize;

unsigned long open_audio(unsigned long f, int s)
   {
	int buf_max;
	unsigned long possible, current;

   audio = open("/dev/dsp", O_WRONLY, 0);
   if (audio == -1)
		end_all("Error opening audio device");

	if (ioctl(audio, SNDCTL_DSP_GETFMTS, &possible) == -1)
		end_all("Error checking formats");
	current = AFMT_QUERY;
	if (ioctl(audio, SNDCTL_DSP_SETFMT, &current) == -1)
		end_all("Could not query current format");
	if (current == AFMT_S16_LE)
		dsp_samplesize = 16;
	else
		{
		if (possible & AFMT_S16_LE)
			{
			current = AFMT_S16_LE;
			if (ioctl(audio, SNDCTL_DSP_SETFMT, &current) == -1)
				end_all("Could not set 16 bit");
			dsp_samplesize = 16;
			}
		else 
			{
			if (current == AFMT_U8)
				dsp_samplesize = 8;
			else
				{
				if (possible & AFMT_U8)
					{
					current = AFMT_U8;
					if (ioctl(audio, SNDCTL_DSP_SETFMT, &current) == -1)
						end_all("Could not set 8 bit");
					dsp_samplesize = 8;
					}
				}
			}
		}
   stereo = s;

   if (ioctl(audio, SNDCTL_DSP_STEREO, &stereo) == -1)
    	end_all("Error setting stereo/mono");

   if (f==0) 
		f = 44100;

   if (ioctl(audio, SNDCTL_DSP_SPEED, &f) == -1)
		end_all("Error setting frequency");

   if (ioctl (audio, SNDCTL_DSP_GETBLKSIZE, &buf_max) == -1)
		end_all("Error getting buffsize");

   buffer = malloc(buf_max);
   buffer16 = (short *)buffer;
   idx = 0;
	switch(dsp_samplesize)
		{
	case 16:
		dsize = 2;
		break;
	case 8:
		dsize = 1;
		break;
	default:
		end_all("Error: unknown dsp_samplesize");
		}
	samples_max = buf_max / dsize;
	current_freq = f;
	total = 0;
	return f;
   }

LOCAL void actually_flush_buffer(void)
   {
   int l,i;

   if (stereo)
	total += idx/2;
   else
	total += idx;
   write(audio, buffer, dsize * idx);
   idx = 0;
   }

void output_samples(long left, long right, int n)
	{
	if (idx >= samples_max - 1)
		actually_flush_buffer();
	switch(dsp_samplesize)
		{
	case 16:				/*   Cool! 16 bits samples */
		add_samples16(left, right, n);
		break;
	case 8:
		add_samples8(left, right, n);
		break;
	default:	/* should not happen */
	   }
   }

void flush_buffer(void)
    {	/* Dummy version */
    }

/*
 * Closing the Linux sound device waits for all pending samples to play.
 */
void close_audio(void)
    {
    actually_flush_buffer();
    close(audio);
    free(buffer);
    }

unsigned long update_frequency(void)
	{
	return 0;
	}

void discard_buffer(void)
	{
	total = 0;
	}
