/* channel.h 
	vi:ts=3 sw=3:
 */

/* $Id: channel.h,v 5.4 1996/05/06 22:48:21 espie Exp espie $
 * $Log: channel.h,v $
 * Revision 5.4  1996/05/06 22:48:21  espie
 * *** empty log message ***
 *
 * Revision 5.3  1996/04/09 21:13:30  espie
 * *** empty log message ***
 *
 * Revision 5.2  1996/03/14 18:03:01  espie
 * *** empty log message ***
 *
 *
 * Revision 5.0  1995/10/21 14:56:11  espie
 * New
 *
 * Revision 4.25  1995/09/03 21:54:59  espie
 * Simplified player.
 *
 * Revision 4.23  1995/09/02 22:18:59  espie
 * automaton loop_counter obsolete.
 *
 * Revision 4.22  1995/08/31 13:30:28  espie
 * bug fix (int -> short )
 *
 * Revision 4.21  1995/08/27 18:43:08  espie
 * tempo
 *
 * Revision 4.17  1995/06/26 15:44:12  espie
 * Removed pblock.
 *
 * Revision 4.16  1995/06/23 09:34:42  espie
 * Added `Special note'
 *
 * Revision 4.14  1995/03/11  21:40:13  espie
 * Added better jump pattern, invert_loop.
 *
 * Revision 4.13  1995/03/04  00:15:28  espie
 * Implemented vibrato control.
 *
 * Revision 4.12  1995/03/01  15:24:51  espie
 * Added start_offset.
 *
 * Revision 4.11  1995/02/21  17:54:32  espie
 * Internal problem: buggy RCS. Fixed logs.
 *
 * Revision 4.9  1995/02/20  22:28:50  espie
 * Tremolo
 *
 * Revision 4.8  1995/02/20  16:49:58  espie
 * Added funk_glissando for command 3.
 *
 * Revision 4.5  1995/02/01  16:39:04  espie
 * Includes moved to defs.h
 *
 * Revision 3.9  1993/11/17  15:31:16  espie
 * audio_channel private.
 * Amiga support.
 * Added finetune.
 *
 * Revision 2.7  1992/11/13  13:24:24  espie
 * Added parameters for extended Retriger command.
 * Added transpose feature.
 * Structured part of the code, especially replay ``automaton''
 * and setting up of effects.
 *
 * Revision 1.5  1991/11/16  16:54:19  espie
 * Bug correction: when doing arpeggio, there might not
 * be a new note, so we have to save the old note value
 * and do the arppeggio on that note.
 * Added fields for arpeggio.
 */

     
#ifndef NUMBER_PATTERNS
#define NUMBER_PATTERNS 128
#endif

#define MAX_ARP 3
     
/* there is no note in each channel initially.
 * This is defensive programming, because some
 * commands rely on the previous note. Checking
 * that there was no previous note is a way to
 * detect faulty modules.
 */

struct sinusoid
	{
	int offset;					/* current offset */
	int depth;					/* current depth */
	int rate;					/* current step rate */
	pitch_delta *table;		/* table to use */
	int reset;					/* flag */
	};

struct channel
   {
   struct sample_info *samp;
   struct audio_channel *audio;
   finetune finetune;
   unsigned int volume;             /* current volume of the sample (0-64) */
   pitch pitch;              /* current pitch of the sample */
   note note;               /* we have to save the note cause */
                           /* we can do an arpeggio without a new note */
    
   pitch arp[MAX_ARP];       /* the three pitch values for an arpeggio */
   int arpindex;           /* an index to know which note the arpeggio is doing */

	struct sinusoid vib;
	struct sinusoid trem;

   int slide;              /* step size of pitch slide */

   pitch pitchgoal;          /* pitch to slide to */
   pitch_delta pitchrate;          /* step rate for portamento */

   int volumerate;         /* step rate for volume slide */


	size_t start_offset;

   int retrig;             /* delay for extended retrig command */
   int current;

	int funk_glissando;	
                           /* current command to adjust parameters */
   void (*adjust) P((struct channel *ch));
	int loop_counter;
	int loop_note_num;

	int invert_speed;
	int invert_offset;
	unsigned long invert_position;
   void (*special)(struct channel *ch);
   };

struct automaton;
