/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include "ubs.h"

int main(int argc, char *argv[]) {
 FILE *fp;
 char target_dir[FILEBUF], song[FILEBUF];
 int i, num_songs, rand_index;
 ubs_table pick_song;

 ubs_table_init(&GLOBAL);
 ubs_table_init(&pick_song);

 ubs_init(argv[0]);

 memset(target_dir, 0x0, FILEBUF);
 if(read_config(DEF_CONFIG, "global", &GLOBAL)) {
  console_error("Can't read global settings in configuration file", FAIL);
 }
 // read in data for whatever the program is actually -named-.  This allows
 // one to have multiple events with the same pick_song binary, simply by
 // creating symlinks to them, the advantage being that each one can have
 // different configuration settings.
 if(read_config(DEF_CONFIG, argv[0], &pick_song)) {
  console_error("Can't read pick_song settings in configuration file", FAIL);
 }
 else {
  if(ubs_table_exists(&pick_song, "dir")) {
   strncpy(target_dir, ubs_table_data(&pick_song, "dir"), FILEBUF);
  }
  else {
   console_error("No directory specified", FAIL);
  }
 }

 if((fp = fopen("tmp/pick_song.dat", "w")) == NULL) {
  return FAIL;
 }
 if((num_songs = parse_dir(fp, target_dir)) == NO_DIR) {
  return FAIL;
 }
 fclose(fp);
 
 if((fp = fopen("tmp/pick_song.dat", "r")) == NULL) {
  return FAIL;
 }

 rand_index = rand() % num_songs;
 for(i = 0; i < rand_index; i++) {
  fgets(song, FILEBUF, fp);
  chomp_line(song);
 }
 fclose(fp);

 if((fp = fopen("tmp/next-event", "w")) == NULL) {
  return FAIL;
 }
 fprintf(fp, "%s", song);
 fclose(fp);

 return OK;
}
