/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Displays information about the programming schedule, as given in the ubs.conf file.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>

#include "ubs-main.h"
#include "ubs-sched.h"

/*+
  Displays information about the programming schedule.

  int cmd_sched Returns OK on success

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_sched(int cmdc, char **cmdv) {
 char ch;
 int format = ENGLISH;

 while((ch = getopt(cmdc, cmdv, "hwces")) != -1) {
  switch(ch) {
   case 'e':
    format = ENGLISH;
    break;
   case 'c':
    format = CSV;
    break;
   case 'w':
    format = HTML;
    break;
   case 's':
    format = SILENT;
    break;
   case 'h':
    sub_help_cmd("sched");
    return OK;
    break;
   default:
    sub_help_cmd("sched");
    return OK;
    break;
  }
 }

 cmdc -= optind;
 cmdv += optind;

 sub_dump_sched(format);

 return OK;
}


/*+
  dump_sched Returns 0 for success

  int mode The output mode
+*/
int sub_dump_sched(int format) {
 int i, j, show_num = -1;

 for(i = 0; i < 7; i++) {
  for(j = 0; j < 48; j++) {
   show_num = find_show(i, j);
   if(format == ENGLISH) {
    if(show_num != -1) {
     printf("Day %d, %02d:%02d: %s\n", i, j / 2, (j % 2) * 30, 
       ALLSHOWS[show_num].show_name);
    }
    else {
     printf("Day %d, %02d:%02d: Default\n", i, j / 2, (j % 2) * 30);
    }
   }
   else if(format == CSV) {
    if(show_num != -1) {
     printf("%d,%d:%02d,%d,%s\n", i, j / 2, (j % 2) * 30, show_num, ALLSHOWS[show_num].show_name);
    }
    else {
     printf("%d,%d:%02d,%d,Default\n", i, j / 2, (j % 2) * 30, show_num);
    }
   }
   else if(format == HTML) {
    if(show_num != -1) {
      if(i % 2 == 0) {
      printf("<tr bgcolor=\"%s\"><td>%d</td><td>%d:%02d</td><td>%d</td><td>%s</td></tr>\n", COLOR1, i, j / 2, (j % 2) * 30, show_num, ALLSHOWS[show_num].show_name);
     }
     else {
      printf("<tr bgcolor=\"%s\"><td>%d</td><td>%d:%02d</td><td>%d</td><td>%s</td></tr>\n", COLOR2, i, j / 2, (j % 2) * 30, show_num, ALLSHOWS[show_num].show_name);
     }
    }
    else {
     if(i % 2 == 0) {
      printf("<tr bgcolor=\"%s\"><td>%d</td><td>%d:%02d</td><td>%d</td><td>Default</td></tr>\n", COLOR1, i, j / 2, (j % 2) * 30, show_num);
     }
     else {
      printf("<tr bgcolor=\"%s\"><td>%d</td><td>%d:%02d</td><td>%d</td><td>Default</td></tr>\n", COLOR2, i, j / 2, (j % 2) * 30, show_num);
     }
    }
   }
  }
 }

 return OK;
}
