/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Frontend to the UBS search engine.  By default, takes a query, and returns any matching files to stdout.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>

#include "ubs-main.h"
#include "ubs.h"

/*+
  Frontend to the UBS search engine

  int cmd_tag Returns OK on success, NO_FILE if the search engine cache cannot be opened.

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_search(int cmdc, char **cmdv) {
 FILE *fp;
 char line_buf[BIGBUF], ch;
 struct log_entry entry;
 int format = ENGLISH;

 while((ch = getopt(cmdc, cmdv, "hwcesr")) != -1) {
  switch(ch) {
   case 'e':
    format = ENGLISH;
    break;
   case 'c':
    format = CSV;
    break;
   case 'w':
    format = HTML;
    break;
   case 's':
    format = SILENT;
    break;
   case 'r':
    return recache();
    break;
   case 'h':
    sub_help_cmd("search");
    return OK;
    break;
   default:
    sub_help_cmd("search");
    return OK;
    break;
  }
 }

 cmdc -= optind;
 cmdv += optind;

 if(cmdc == 0) {
  sub_help_cmd("search");
  return FAIL;
 }

 if((fp = fopen("tmp/searchcache.dat", "r")) == NULL) {
  printf("Unable to open search cache\n");
  return NO_FILE;
 }

 while(fgets(line_buf, BIGBUF, fp)) {
  bzero(&entry, sizeof(struct log_entry));
  read_log(&entry, line_buf);
  if(ubs_strcasestr(entry.field1, cmdv[0]) ||
   ubs_strcasestr(entry.field2, cmdv[0]) ||
   ubs_strcasestr(entry.field3, cmdv[0])) {
   sub_print_tag(entry.field1, format);
  }
 }

 fclose(fp);
 return OK;
}
