/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Shows the ID3/Vorbis tag for a given filename
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>

#include "ubs-main.h"

/*+
  Shows the ID3/Vorbis tag for a given filename

  int cmd_tag Returns OK on success, or whatever sub_print_tag() returns.

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_tag(int cmdc, char **cmdv) {
 char ch;
 int format = ENGLISH;

 while((ch = getopt(cmdc, cmdv, "hwces")) != -1) {
  switch(ch) {
   case 'e':
    format = ENGLISH;
    break;
   case 'c':
    format = CSV;
    break;
   case 'w':
    format = HTML;
    break;
   case 's':
    format = SILENT;
    break;
   case 'h':
    sub_help_cmd("tag");
    return OK;
    break;
   default:
    sub_help_cmd("tag");
    return OK;
    break;
  }
 }

 cmdc -= optind;
 cmdv += optind;

 if(cmdc == 0) {
  sub_help_cmd("tag");
  return FAIL;
 }

 return sub_print_tag(cmdv[0], format);
}

/*+
  Opens up the music file and finds the tag, printing it out to the screen.  This is done via the get_media_tag() function.

  int sub_print_tag Returns OK on success, NO_FILE if the get_media_tag() call fails.

  char *sname The filename to query

  int format Output format to use.
+*/
int sub_print_tag(char *sname, int format) {
 struct media_tag song_tag;

 if(get_media_tag(sname, &song_tag)) {
  printf("ERROR: Unable to open file '%s'\n", sname);
  return NO_FILE;
 }

 if(format == ENGLISH) {
  printf("\"%s\" by %s\n", song_tag.title, song_tag.artist);
 }
 else if(format == CSV) {
  printf("%s,%s\n", song_tag.title, song_tag.artist);
 }
 else if(format == HTML) {
  printf("<tr><td><i>%s</i></td><td>%s</td></tr>\n", song_tag.title, song_tag.artist);
 }

 return OK;
}
