
/* 	
			UNICON PROJECT

   		    Copyright (C) 1999 TLDN
	
   Authors:	Li Qi Chen <chrisl@turbolinux.com.cn>
		Arthur Ma  <arthur.ma@turbolinux.com.cn>
		Justin Yu  <justiny@turbolinux.com.cn>

   Homepage:    http://turbolinux.com.cn/TLDN/chinese/project/unicon/index.html
   Mailinglist: unicon@turbolinux.com.cn 	
   Download:    http://turbolinux.com.cn/TLDN/chinese/project/unicon/download.html

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* hzinput.h -- definitions used in input methods */

#ifndef HZINPUT_H
#define HZINPUT_H
#include <xl_sysphrase.h>

#define MAX_INPUT_LENGTH        17
#define MAGIC_NUMBER            "CCEGB"
#define CIN_ENAME_LENGTH        24
#define CIN_CNAME_LENGTH        16
#define MAX_PHRASE_LENGTH       20 
#define SELECT_KEY_LENGTH       16 
#define END_KEY_LENGTH          16

#define InputAreaX              8
  // 0-7 input method name, 8 input chars
#define IntCode_SelectionX      13
#define SelectionX             (InputAreaX + MAX_INPUT_LENGTH + 1) 
// 26
   // 8-23  16 max input chars
/* #define SelectionXMax           78  */
extern int SelectionXMax; 

/* key of toggle input method */

#define NR_INPUTMETHOD 9
 /* 0-9, 0 PinYin, 9 IntCode */

/* define type of ITEM */
#define   IMM_DOUBLECHAR           0
#define   IMM_PHRASE               1
#define   IMM_DEL_PHRASE           0xff

typedef struct 
{
    u_long  key1;                  /* sizeof(ITEM=12) */
    u_long  key2;
    u_long  nPhrase;            
//    u_short frequency;
    u_char  type; 
} ITEM;

typedef struct __AssociatePhrase__
{
    u_short total;
    ITEM **pPhrase;
} AssociatePhrase;

typedef struct {
    char magic_number[sizeof(MAGIC_NUMBER)];    /* magic number */
    char ename[CIN_ENAME_LENGTH];               /* ascii name */
    char cname[CIN_CNAME_LENGTH];               /* prompt */
    char selkey[SELECT_KEY_LENGTH];             /* select keys */

    char last_full;         /* last full code need a more SPACE? */
    int  TotalKey;          /* number of keys needed */
    int  MaxPress;          /* Max len of keystroke */
    int  MaxDupSel;         /* how many keys used to select */
    int  TotalChar;         /* Defined characters */

    unsigned char KeyMap[128];     /* Map 128 chars to 64(6 bit) key index */
    unsigned char KeyName[64];     /* Map 64 key to 128 chars */
    unsigned short KeyIndex[64];   /* 64 key first index of TotalChar */

    int TotalPhrase;        /* Total Phrase Number */
    ITEM *item;             /* item */
    int TotalAssociatePhrase;
    AssociatePhrase *pAssociatePhrase;
} hz_input_table;

typedef struct __HZ_INPUT_TABLE__
{
   int IsHanziInput;            /* 0 for ascii, 
                                   1 for hanzi input */
   int IsFullChar;              /* 0 for half char, 1 for full char */
   int IsFullComma;             /* 0 for half comma, 1 for full comma */
   int IsSysMenu;               /* 0 is no menu, 1 is menu */
   int IsHelpMenu;               /* 0 is no menu, 1 is menu */
   int current_method;
   hz_input_table *cur_table;
   char   seltab[16][MAX_PHRASE_LENGTH];
   long   seltab_phrase[16];

   int CurSelNum;              /* Current Total Selection Number */
   unsigned long InpKey[MAX_INPUT_LENGTH],
                 save_InpKey[MAX_INPUT_LENGTH];

   /* Input key buffer */
   int InputCount, InputMatch, StartKey, EndKey;
   int save_StartKey, save_EndKey,
       save_MultiPageMode, save_NextPageIndex,
       save_CurrentPageIndex;

   int NextPageIndex,
       CurrentPageIndex,
       MultiPageMode;
   
   unsigned long val1, val2, key1, key2;
   int IsAssociateMode;
   int CharIndex[15];   // starting index of matched char/phrases
   int UseAssociateMode;
   int IsFullCommaInChinese;
   int IsFullCommaInEnglish;
   int IsFullCharBackup; 
   int IsHanziInputBackup;
   int MaxSelectLen;
   int MAX_SEL_LENGTH;

   /* Output Sorting Support */
   u_char bIsFinishSorting;
   long TotalOutputPhrase;
   long OutputPhrase[32000];
   /* System Flush Support */
   char szTabFileName[256];
   char szSysPhraseFile[256];
   TL_SysPhrase_T *pSysPhrase;
} HzInputTable_T;

extern void ResetInput (HzInputTable_T *pClient);

#endif
