#ifndef __AHZINPUT_HPP__
#define __AHZINPUT_HPP__
#include <MyInputArea.hpp>
#include <ImmClient.h>
#include <Phrase.h>
#include <MyConfig.hpp>
#include <UniKey.hpp>

#define  MAX_SELECT_ITEM   10

class CAImmHzInput 
{
/*
private:
    char TmpBuf[8192 * 2];
    PhraseItem TmpPhraseItem[MAX_SELECT_ITEM];
*/
protected:
    /* Key Hooker */
    CUniKey *pCMyKey; 
    int nTty;
    int nTotalSelection;

    /* Input Area Operator */
    CMyInputArea  *pCMyInputArea;

    /* Configuration */
    CMyConfig *pMyConfig; 

    /* Server Operating Handler */
    ImmServer_T ImmServer;
    IMM *pImm;

    /* Input State Indicators */
    char bShowFirstStartMsg,
         IsHelpMenu,
         IsSysMenu,
         IsFullChar,
         IsHanziInput,
         IsFullComma;
    char IsHanziInputBackup,
         IsFullCharBackup,
         IsFullCommaInChinese,
         IsFullCommaInEnglish;

    /* Help Items Indicator */
    int  ShowTipItem;

    /* Make Phrase state Indicator */
    int IsMakingPhrase;
    char szUserPhraseCode[32];
    char szUserPhrase[256];
    char szOldMethod[256];
private:
    int  FillMatchesToShowBuffer ();
    void RefreshPhraseShowTable ();
    bool UpAddPhraseToShow (PhraseItem *p); 
    bool DownAddPhraseToShow (PhraseItem *p); 
protected:
    int  OpenInputMethod (char *szImmModule, char *szImmTable, 
                         u_long type, char *szMethod);
    int  CloseInputMethod ();
    void ResetInput ();
    int  RefreshInputMode ();
public:
    CAImmHzInput (int nTty, ImmServer_T ImmServer, CMyConfig *pMyConfig,
               CUniKey *pCMyKey0);
    virtual ~CAImmHzInput ();

    /* Key Filter control */
    int KeyFilter (u_char key, char *buf, int *len);

    /* Display Control */
    void RefreshInputArea();

    /* Make Phrase Support */
    int  MakingUserPhrase (char *szCode, char *szPhrase);
    void GetInputDisplay (char *szCode, int len);
    int  WriteUserDefinedPhrase (char *szPhrase, int len);
    void DoFlush ();
};

#endif

