#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <assert.h>

#include <APhrase.hpp>

CAPhrase::CAPhrase (CMemPhrase *pCMemPhrase0, 
                    u_long nInitMaxItem, 
                    u_long DynIncreaseStep)
{
    pCMemPhrase  = pCMemPhrase0;
    ppPhraseItem = (PhraseItem **) 
                  malloc (nInitMaxItem * sizeof (PhraseItem *));
    if (ppPhraseItem == (PhraseItem **) NULL)
    {
        printf ("No enough memory to run in CAPhrase ()\n");
        exit (0);
    }
    MaxItem = nInitMaxItem;
    nCurItem = 0;
    DynIncStep = DynIncreaseStep;
}

CAPhrase::~CAPhrase ()
{
    free (ppPhraseItem);
}

void CAPhrase::AddPhraseItem (PhraseItem *p)
{
    if (nCurItem >= MaxItem)
    {
        MaxItem += DynIncStep;
        ppPhraseItem = (PhraseItem **) realloc 
                      (ppPhraseItem, MaxItem * sizeof (PhraseItem *));
        if (ppPhraseItem == (PhraseItem **) NULL)
        {
            printf ("No enough memory to run in CAPhrase ()\n");
            exit (0);
        }
    }   
    if (pCMemPhrase  != NULL)
        ppPhraseItem[nCurItem++] = pCMemPhrase->pAddPhraseItem (p);
    else
        ppPhraseItem[nCurItem++] = p;
}

PhraseItem * CAPhrase::pGetPhraseItem (u_long n)
{
    assert (n < nCurItem);
    return ppPhraseItem[n];
}

u_long CAPhrase::GetTotalItem ()
{
    return nCurItem;
}

static int compareByFreq (const void *a1, const void *a2)
{
    const PhraseItem *p1 = (PhraseItem *) a1;
    const PhraseItem *p2 = (PhraseItem *) a2;
    if (*p1->frequency > *p2->frequency)
        return 1;
    else if (*p1->frequency < *p2->frequency)
        return -1;
    else
        return 0;
}

static int compareByKeys (const void *a1, const void *a2)
{
    const PhraseItem *p1 = (PhraseItem *) a1;
    const PhraseItem *p2 = (PhraseItem *) a2;
    return strcmp (p1->szKeys, p2->szKeys);
}

void CAPhrase::SortByFreq ()
{
    qsort (ppPhraseItem, nCurItem, sizeof (PhraseItem *), compareByFreq);
}

void CAPhrase::SortByKeys ()
{
    qsort (ppPhraseItem, nCurItem, sizeof (PhraseItem *), compareByKeys);
}

