#ifndef __UNIKEY_HPP__
#define __UNIKEY_HPP__

#include <MyTypes.h>
#include <unikey.h>

class CUniKey
{
private:
    int fd;
    MyVideoInfo_T MyVideoInfo;
    int ChineseInput_X;
    int ChineseInput_Y;
    int SelectionXMax;
private:
    int GetCurrentTTY ();
    int TestFBExist ();
    /* Key Hooker */
    int WriteOsKeys (TTY_KEY_T *ui);
    int ReadOsKeys (TTY_KEY_T *ui);
public:
    CUniKey (char *szDevice);
    ~CUniKey ();

    /* Key Hooker */
    int WriteKeys (int nTty, char *szKey, int total);
    int ReadKeys (TTY_KEY_T *ui);

    /* System Dependent Input Display */
    void InputAreaSPut (int x, int y, u_char ch, 
                        VColor fg, VColor bg);
    void InputAreaWPut (int x, int y, 
                u_char ch1, u_char ch2, VColor fg, VColor bg);
    void InputAreaClear (int x1, int y1, int x2, int y2, VColor color);
    void InputAreaOutput (int x, char *Str, VColor fg, VColor bg);

    /* Video Info Operations */
    void GetVideoInfo (MyVideoInfo_T *p);
    void SetVtChangeSize ();
    void SetVtRestoreSize ();
    int  GetVideoPixelWidth ();
    int  GetVideoPixelHeight ();
    int  GetFontWidth ();
    int  GetFontHeight ();
    void ResizeTerm (int nRow);
};

#endif

