

/* 	
			UNICON PROJECT

   		    Copyright (C) 1999 TLDN
	
   Authors:	Li Qi Chen <chrisl@turbolinux.com.cn>
		Arthur Ma  <arthur.ma@turbolinux.com.cn>
		Justin Yu  <justiny@turbolinux.com.cn>

   Homepage:    http://turbolinux.com.cn/TLDN/chinese/project/unicon/index.html
   Mailinglist: unicon@turbolinux.com.cn 	
   Download:    http://turbolinux.com.cn/TLDN/chinese/project/unicon/download.html

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */


#ifndef __XL_HZFB_H__

typedef struct _hzfb 
{
    //geometry
    u_int width;                //real screen
    u_int height;

    //memory
    unsigned char *fb_mem;
    u_int mem_len;

    //graphics
    u_int bits_per_pixel;
    u_int line_length;
} HzFb_T;

extern int HzFbInit(HzFb_T *fbinfo);
extern int HzFbExit(HzFb_T *fbinfo);
extern void FbPutAscii (HzFb_T *fbinfo, int x, int y, 
                        long color, unsigned char c);
extern void FbPutChinese (HzFb_T *fbinfo, int x, int y,
                        long color, unsigned char c1, unsigned char c2);
extern void FbClearRect (HzFb_T *fbinfo, unsigned char color, int y1, int y2);
extern int GetFbHeight (HzFb_T *fbinfo);
extern int GetFbWidth (HzFb_T *fbinfo);
extern int GetCurrentTTY (void);

#endif /* __XL_HZFB_H__ */


