/**
 * Uptime Client v4.2
 *
 * options.h
 */

#ifndef _OPTIONS_H_
#define _OPTIONS_H_ 1

/* Macros */
#define MAX_LINE_LEN	1024
#define MAX_KEY_LEN	64
#define MAX_VAL_LEN	256

#define LINE_ERR	0
#define LINE_EMPTY	1
#define	LINE_COMMENT	2
#define	LINE_OPTION	3

#define AUTHKEY_REQUIRED_LEN	32
#define UPSERVER_MAXLEN		256
#define PROXYSERVER_MAXLEN	256
#define PROXYUSER_MAXLEN	32
#define PROXYPASS_MAXLEN	32
#define PIDFILE_MAXLEN		256

/* External global variables: config options */
extern char cfg_authkey[AUTHKEY_REQUIRED_LEN+1];
extern char cfg_upserver[UPSERVER_MAXLEN+1];
extern int  cfg_interval;
extern char cfg_pidfile[PIDFILE_MAXLEN+1];
extern char cfg_proxyserver[PROXYSERVER_MAXLEN+1];
extern int  cfg_proxyport;
extern char cfg_proxyuser[PROXYUSER_MAXLEN+1];
extern char cfg_proxypass[PROXYPASS_MAXLEN+1];
extern int  cfg_sendidle;
#if defined(PLATFORM_UNIXWARE)
extern int cfg_sendload;
#else
extern int cfg_sendload;
#endif
extern int cfg_sendos;
extern int cfg_sendoslevel;
extern int cfg_sendcpu;
extern int cfg_sendcpulevel;

/* External global variables: set to reflect config options */
extern int have_proxyserver;
extern int have_proxyport;
extern int have_proxyuser;
extern int have_proxypass;

/* External functions */
extern int readconfig(void);

#endif
