/**
 * @filename	stats-w2k.c
 *
 * @desc	Retrieve stats for the Windows NT4/2000 platforms
 */

/* My includes */
#include "upclient.h"
#include "options.h"
#include "stats.h"

/* System includes */
#include <pdh.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <windows.h>

/**
 * @desc	Get statistics
 */
void getstats(unsigned long *puptime, double *pload, int *pidle, char *os, char *oslevel, char *cpu) {
  HQUERY                myQuery;
  HCOUNTER              hPdhCounter;
  PDH_STATUS            nStatusCode;
  PDH_FMT_COUNTERVALUE  pdhfmtcv;
  LONGLONG              lUptime;
  OSVERSIONINFO         osVersionInfo;
  SYSTEM_INFO           si;
  int                   success = 0; /* false */

  /* open query to get perfomance data */
  if(PdhOpenQuery(NULL, 0, &myQuery) == ERROR_SUCCESS) {
    /* add system uptime to the query */
    if(PdhAddCounter(myQuery, "\\\\.\\System\\System Up Time", 0, &hPdhCounter) == ERROR_SUCCESS) {
      /* execute query */
      if(PdhCollectQueryData(myQuery) == ERROR_SUCCESS) {
        nStatusCode = PdhGetFormattedCounterValue(hPdhCounter, PDH_FMT_LARGE, NULL, &pdhfmtcv);

        if(nStatusCode == ERROR_SUCCESS && pdhfmtcv.CStatus==0) {
          lUptime = pdhfmtcv.largeValue;
          lUptime /= 60;   // convert to minutes;

          /* convert 64-bits value -> 32 bits value... inaccurate when system longer up than 136 years */
          *puptime = (unsigned long)lUptime;

          success = 1;
        }
      }
    }
    /* close query */
    PdhCloseQuery(myQuery);
  }

  /* when failing... which should *never* happen return 0 for uptime */
  if(!success) {
    *puptime = 0;
  }

  /* this *must* be windows if its built against PLATFORM_WINNT */
  strcpy(os, "Windows");

  /* retrieve os version */
  osVersionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  GetVersionEx(&osVersionInfo);

  switch(osVersionInfo.dwMajorVersion) {
    case 5:
      strcpy(oslevel, "2000");
      break;
    case 4:
      if(osVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
        strcpy(oslevel, "NT");
      } else {
        strcpy(oslevel,(osVersionInfo.dwMinorVersion == 0 ? "95" : "98"));
      }
      break;
    case 3:
      if(osVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT) {
        strcpy(oslevel, "NT 3.x");
      } else {
        /* This should only happen if Win32s is installed, should never happen */
        strcpy(oslevel, "3.x");
      }
      break;
    default:
      strcpy(oslevel, "unknown");
  }

  /* retrieve system info */
  GetSystemInfo(&si);
  if(si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_ALPHA) {
    strcpy(cpu, "alpha");
  } else {
    if(si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL) {
      sprintf(cpu, "i%d86", si.wProcessorLevel);
    } else {
      strcpy(cpu, "unknown");
    }
  }
}
