/* @(#)unexpand.c	1.6 */

#include <config.h>

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <utf.h>
#include <utftools.h>

static char sccsid[] = "@(#)unexpand.c	1.6";

static char usage[] = "unexpand [-v] [-a] [-t tabs] [--] [file ...]";

static int tabs;
static int all;

static void unexpandfile(char *);
static int	unexpandline(FILE *);

int
main(int argc, char **argv)
{
	int c;
	
	errorname = "unexpand";

	all = 0;
	tabs = 8;

	opterr = 0;
	while ((c = getopt(argc, argv, "vat:")) != -1) {
		switch (c) {
		case 'v':
			fprintf(stderr, "%s\n", sccsid);
			exit(0);
		case 't':
			errno = 0;
			tabs = strtoix(optarg, 10);
			if (errno == ERANGE || errno == EDOM || tabs < 0)
				fatal("-t option must specify a decimal integer greater than zero");
			break;
		case 'a':
			all = 1;
			break;
		default:
			fprintf(stderr, "usage: %s\n", usage);
			exit(1);
		}
	}

	if (argv[optind] == 0) {
		unexpandfile("-");
	} else {
		while (argv[optind] != 0) {
			unexpandfile(argv[optind]);
			++optind;
		}
	}
	
	exit(0);
}

static void
unexpandfile(char *fname)
{
	FILE *fp;

	if (strcmp(fname, "-") == 0)
		fp = stdin;
	else {
		fp = fopen(fname, "r");
		if (fp == 0)
			fatal("unable to open %s", fname);
	}

	while (unexpandline(fp) != EOF)
		;

	if (strcmp(fname, "-") != 0)
		fclose(fp);
}

static int
unexpandline(FILE *fp)
{
	int r;
	int col;
	int targetcol;

	col = 0;
	r = fgetr(fp);
	while (r != EOF && r != '\n') {
		if ((r == ' ' || r == '\t') && (col == 0 || all)) {
			targetcol = col;
			while (r == ' ' || r == '\t') {
				if (r == ' ')
					++targetcol;
				else 
					targetcol = (targetcol / tabs + 1) * tabs;
				r = fgetr(fp);
			}
			if (targetcol - col == 1)
				fputr(' ', stdout);
			else {
				while (col / tabs < targetcol / tabs) {
					fputr('\t', stdout);
					col = (col / tabs + 1) * tabs;
				}
				while (col < targetcol) {
					fputr(' ', stdout);
					++col;
				}
			}
		} else {
			fputr(r, stdout);
			++col;
			r = fgetr(fp);
		}
	}

	if (r == '\n')
		fputr('\n', stdout);

	return r;
}

