(declare (file defs vars) special)
(defun save nil
   (lets ((file (alloc (lets ((prompt " FILE NAME> "))
                        (skipline)
                        (readline))))
          (defs) (vars))
    (loop (and (stringp file) (exit))
          (setq file (alloc (lets ((prompt " ENTER FILE NAME AGAIN> "))
                             (readline)))))
    (setq file (stream file))
    (catch 'save
       (do ((standard-input (inopen file))
            (err:end-of-file (function (lambda (s) (throw 'save)))))
           (nil)
           (lets ((form (read)))
            (match form
               (('putd ('quote fn) ('quote def))
                (or (definedp fn) (eval form))
                (push fn defs))
               (('defun fn . def)
                (or (definedp fn) (eval form))
                (push fn defs))
               (('macro fn . def)
                (or (definedp fn) (eval form))
                (push fn defs))
               (('defmacro fn . def)
                (or (definedp fn) (eval form))
                (push fn defs))
               (('set ('quote var) ('quote value))
                (or (boundp var) (eval form))
                (push var vars))
               (('setq var ('quote value))
                (or (boundp var) (eval form))
                (push var vars))
               (x (format "UNRECOGNIZABLE FORM READ IN -- /S/N" form)
                  (break))))))
    (progn (cond ((null defs)
                  (princ "NO FUNCTION IS CURRENTLY SAVED.")
                  (terpri))
                 (t (princ "FUNCTIONS SAVED ARE ... ")
                    (prind (reverse defs))))
           (do ((prompt " ANY TO ADD> " " MORE> "))
               ((or (not (string-search-not-char " " (current-line)))
                    (progn (or (string-search-not-char
                                  " "
                                  (current-line)
                                  (cursor terminal-input))
                               (skipline))
                           (not (string-search-not-char " " (current-line)))))
                (skipline))
               (lets ((x (read)))
                (and (symbolp x) (not (memq x defs)) (push x defs))))
           (or (null defs)
               (do ((prompt " ANY TO DELETE> " " MORE> "))
                   ((or (not (string-search-not-char " " (current-line)))
                        (progn (or (string-search-not-char
                                      " "
                                      (current-line)
                                      (cursor terminal-input))
                                   (skipline))
                               (not (string-search-not-char " " 
                                     (current-line)))))
                    (skipline))
                   (lets ((x (read)))
                    (and (symbolp x)
                         (memq x defs)
                         (setq defs (delq x defs)))))))
    (progn (cond ((null vars)
                  (princ "NO VARIABLE IS CURRENTLY SAVED.")
                  (terpri))
                 (t (princ "VARIABLES SAVED ARE ... ")
                    (prind (reverse vars))))
           (do ((prompt " ANY TO ADD> " " MORE> "))
               ((or (not (string-search-not-char " " (current-line)))
                    (progn (or (string-search-not-char
                                  " "
                                  (current-line)
                                  (cursor terminal-input))
                               (skipline))
                           (not (string-search-not-char " " (current-line)))))
                (skipline))
               (lets ((x (read)))
                (and (symbolp x) (not (memq x vars)) (push x vars))))
           (or (null vars)
               (do ((prompt " ANY TO DELETE> " " MORE> "))
                   ((or (not (string-search-not-char " " (current-line)))
                        (progn (or (string-search-not-char
                                      " "
                                      (current-line)
                                      (cursor terminal-input))
                                   (skipline))
                               (not (string-search-not-char " " 
                                     (current-line)))))
                    (skipline))
                   (lets ((x (read)))
                    (and (symbolp x)
                         (memq x vars)
                         (setq vars (delq x vars)))))))
    (lets ((standard-output (outopen file)))
     (mapc (nreverse defs)
        (function
         (lambda (fn)
          (match (getd fn)
             (('lambda . body) (prind `(defun ,fn . ,body)))
             (('macro
               'lambda
               ('@)
               ('match
                '@
                (args . body)
                ('@ ('funcall 'err:argument-type '@ ('quote f)))))
              (prind `(defmacro ,fn ,args . ,body)))
             (('macro 'lambda . body) (prind `(macro ,fn . ,body)))))))
     (mapc (nreverse vars)
        (function (lambda (x) (terpri) (prind `(setq ,x ',(eval x)))))))
    (close file)))
