/* vifm
 * Copyright (C) 2001 Ken Steen.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<ncurses.h>
#include<signal.h>
#include<unistd.h> /* alarm() */
#include<sys/stat.h> /* stat */
#include<sys/time.h> /* timeval */
#include<time.h>

#include "file_info.h"
#include "filelist.h"
#include "filetype.h"
#include "keys.h"
#include "menus.h"
#include "signals.h"
#include "status.h"
#include"config.h"
#include"ui.h"

/* Handle term resizing in X */
static void
received_sigwinch()
{
	if(!isendwin())
		redraw_window();
	else
		curr_stats.need_redraw = 1;
}

void
switch_views(void)
{
	FileView *tmp = curr_view;
	curr_view = other_view;
	other_view = tmp;
}

/* Checks if the vifmrc config file has changed. */
static void
check_config_file(void)
{
	char buf[256];
	struct stat stat_buf;
	snprintf(buf, sizeof(buf), "%s/vifmrc%.1f", cfg.config_dir, VERSION);
	if(stat(buf, &stat_buf) == 0)
	{
		if(stat_buf.st_mtime != curr_stats.config_file_mtime)
		{
			clear_filetypes();
			read_config_file();
			curr_stats.config_file_mtime = stat_buf.st_mtime;
		}

	}
}

/*
 * This checks the modified time of the current directory.  If it has changed
 * it reloads the file list. 
 */
static void
check_for_file_changes(int signo)
{
	if((!isendwin()) && (!curr_stats.popup_showing) &&(!curr_stats.getting_input))
	{
		struct stat s;
		int changed_dir = 0;
		struct tm *tm_ptr;
		time_t now;

		time(&now);
		tm_ptr = localtime(&now);

		curr_stats.freeze = 1;
		curs_set(0);

		if(!cfg.show_full)
		{
			stat(other_view->curr_dir, &s);
			if(s.st_mtime != other_view->dir_mtime)
			{
				switch_views();
				change_directory(curr_view, curr_view->curr_dir);
				changed_dir = 1;
				load_dir_list(curr_view, 1);
				mvwaddstr(curr_view->win, curr_view->curr_line, 0, " *");
				curr_view->dir_mtime = s.st_mtime;

			}
		}
		if(changed_dir)
			switch_views();
		
		stat(curr_view->curr_dir, &s);
		if(s.st_mtime  != curr_view->dir_mtime)
		{
			change_directory(curr_view, curr_view->curr_dir);
			changed_dir = 0;
			load_dir_list(curr_view, 1);
			wattron(curr_view->win, COLOR_PAIR(CURR_LINE_COLOR) | A_BOLD);
			mvwaddstr(curr_view->win, curr_view->curr_line, 0, "=>");
			wattroff(curr_view->win, COLOR_PAIR(CURR_LINE_COLOR) | A_BOLD);
			wmove(curr_view->win, curr_view->curr_line, 0);
			curr_view->dir_mtime = s.st_mtime;
			if(cfg.show_full)
				show_full_file_properties(curr_view);
			else
				update_stat_window(curr_view);

			update_all_windows();
		}

		if(changed_dir)
		{
			change_directory(curr_view, curr_view->curr_dir);
			update_all_windows();
		}

			curr_stats.freeze = 0;
	}

	curr_stats.freeze = 0;
	check_config_file();
	alarm(1);
}



void
setup_signals(void)
{
	struct sigaction resize_action;

	resize_action.sa_handler = received_sigwinch;
	sigemptyset(&resize_action.sa_mask);
	resize_action.sa_flags = SA_RESTART;
	sigaction(SIGWINCH, &resize_action, NULL);
	
	/* This should be changed to a timer to allow the user to set the update */
	signal(SIGALRM, check_for_file_changes);
	alarm(5);
}
