(define (lvar-functor optutil-mod varset-mod error-mod)

  (module lvar-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use lv-sig)
    (use optutil-mod optutil-sig)
    (use varset-mod varset-sig)
    (use error-mod error-sig)

    (define (livevar exp)

      (define (init exp)
	(let ((body (ee-body exp)))
	  (case (ee-type exp)
	    ((clambda) 
	     (info-ee
	      'clambda '(() . ())
	      (list (car body)
		    (init (cadr body))
		    (caddr body)
		    (cadddr body)
		    (livevar (caddddr body)))))
	    ((cvlambda)
	     (info-ee
	      'cvlambda '(() . ())
	      (list (car body)
		    (init (cadr body))
		    (caddr body)
		    (cadddr body)
		    (caddddr body)
		    (livevar (cadddddr body)))))
	    ((cdelay)
	     (info-ee
	      'cdelay '(() . ())
	      (list (car body)
		    (init (cadr body))
		    (caddr body)
		    (livevar (cadddr body)))))
	    ((local global quote integrable)
	     (info-ee 'wrap '(() . ()) exp))
	    (else
	     (let ((r (generic init exp)))
	       (ee-info! r '(() . ()))
	       r)))))

      (define change #f)

      (define (do-lv exp nafter labs)
	(let* ((nbefore (get-lv exp nafter labs))
	       (obefore (lv-before exp))
	       (oafter (lv-after exp)))
	  (if (or (< (length obefore) (length nbefore))
		  (< (length oafter) (length nafter)))
	      (set! change #t))
	  (ee-info! exp (cons nbefore nafter))
	  nbefore))

      (define (get-lv exp c labs)

	(define (same-do-lv exp c)
	  (do-lv exp c labs))

	(define (app-lv l c)		; eval. order: right->left
	  (if (not (pair? l))
	      c
	      (app-lv (cdr l)
		      (same-do-lv (car l) c))))

	(case (ee-type exp)
	  ((wrap)
	   (let ((body (ee-body exp)))
	     (if (eqv? (ee-type body) 'local)
		 (varset+1 body c)
		 c)))
	  ((set!) (same-do-lv (cadr (ee-body exp)) c))
	  ((if)
	   (let ((body (ee-body exp)))
	     (same-do-lv (car body)
			 (varset+ 
			  (same-do-lv (cadr body) c)
			  (same-do-lv (caddr body) c)))))
	  ((app) (app-lv (ee-body exp) c))
	  ((let)
	   (let ((body (ee-body exp)))
	     (same-do-lv (cadaar body)
			 (varset- (same-do-lv (cadr body) c)
				  (list (caaar body))))))
	  ((clambda cvlambda cdelay)
	   (same-do-lv (cadr (ee-body exp)) c))
	  ((label)
	   (let* ((body (ee-body exp))
		  (bl (cadr body))
		  (vars (list->varset (map car bl)))
		  (c1 (varset-
		       (do-lv (caddr body)
			      c
			      (cons (cons (car body)
					  (varset+
					   vars
					   (varset+ c (lv-before exp))))
				    labs))
		       vars)))
	     (app-lv (reverse (map cadr bl)) c1)))
	  ((goto)
	   (let* ((body (ee-body exp))
		  (lab (assv (car body) labs)))
	     (app-lv (reverse (cdr body)) (cdr lab))))
	  (else (bug "livevar: unexpected expression type"))))

      (let ((exp (init exp)))

	(define (loop)
	  (set! change #f)
	  (do-lv exp '() '())
	  (if change
	      (loop)))

	(loop)
	exp))))
