/*
 * except.h -- Declarations for Scheme exception handling
 *
 * (C) m.b (Matthias Blume); May 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: except.h,v 2.4 1994/11/03 21:39:20 blume Exp $
 */

# ifndef EXCEPT_H_
# define EXCEPT_H_

# include "noreturn.h"

/* Recoverable errors... (possibly triggered by Scheme constructs) */
extern void NORETURN error (const char *, ...) NRUTERON;
/* non-recoverable errors (finish Scheme's work) */
extern void NORETURN fatal (const char *) NRUTERON;
/* Recoverable error imposed by an implementation restriction */
extern void NORETURN restriction (const char *, ...) NRUTERON;
/* Warning messages */
extern void warning (const char *, ...);
/* Errors, which reset the system to some well-defined state */
extern void NORETURN reset (const char *) NRUTERON;

/* Most common error message canned */
extern void NORETURN badarg (const char *fname, void *arg) NRUTERON;

# endif
