/*
 * keyword.c -- Implementation of variables, which hold the Scheme keywords
 *
 * (C) m.b (Matthias Blume); Apr 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: keyword.c,v 2.6 1994/11/12 22:20:17 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: keyword.c,v 2.6 1994/11/12 22:20:17 blume Exp $")

# include "keyword.h"
# include "storage.h"
# include "Symbol.h"

# include <string.h>

ScmKeyword ScmKeyword_array [] = {
  { NULL, "quasiquote" },
  { NULL, "quote" },
  { NULL, "unquote" },
  { NULL, "unquote-splicing" },
};

# define NKW (sizeof ScmKeyword_array / sizeof(ScmKeyword))
# define sym(x) ScmMakeSymbol (x, strlen (x))

static void iterator (void *varray, MEM_visitor proc, void *cd)
{
  int i;
  ScmKeyword *array = varray;

  for (i = 0; i < NKW; i++)
    (* proc) ((void *)&(array [i].ptr), cd);
}

void ScmInitializeKeywords (void)
{
  int i;

  MEM_root (ScmKeyword_array, iterator);
  for (i = 0; i < NKW; i++)
    ScmKeyword_array[i].ptr = sym (ScmKeyword_array[i].name);
}
