/*
 * mkalign.c -- Create header file defining align_t
 *
 * (C) m.b (Matthias Blume); 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * Note to whom it may concern:  the program presented in this file uses
 *  a common heuristic to determine the type with the strongest alignment
 *  requirements.  It may fail on your particular system.  If so then create
 *  the file align.h yourself in the spirit of what has been produced by
 *  this program.
 *
 * $Id: mkalign.c,v 2.5 1994/11/12 22:23:02 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: mkalign.c,v 2.5 1994/11/12 22:23:02 blume Exp $")

# include <stdio.h>
# include <stdlib.h>

struct simple {
	long l;
	double d;
};

struct complex {
	double d1, d2;
};

/* make a ``picky'' compiler (like gcc -Wmissing-prototypes) happy: */
extern int main (int, char **);

/*ARGSUSED*/
int main (int argc, char **argv)
{
  fputs ("/*\n * File has been generated automatically"
	 " -- don't change it!\n */\n"
	 "\n# ifndef ALIGN_H_\n# define ALIGN_H_\n\ntypedef\n",
	 stdout);
  if (sizeof (struct simple) < sizeof (struct complex))
    fputs ("long", stdout);
  else
    fputs ("double", stdout);
  fputs (" MEM_align_t;\n\n# endif\n", stdout);
  return EXIT_SUCCESS;
}
