/*
 * type.h -- Definition of ScmType(...)
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Nov 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: type.h,v 2.4 1994/09/01 20:10:48 blume Exp $
 */

# ifndef TYPE_H_
# define TYPE_H_

# define ScmType(name) (&MEM_ ## name ## _1)

/*
 * Some convenience macros to interface with the storage module...
 */
# define SCM_NEW(v,t) MEM_NEW (v, ScmType (t), MEM_UNITS (sizeof (Scm ## t)))
# define SCM_VNEW(v,t,l,u) \
  MEM_NEW (v, ScmType (t), \
           MEM_UNITS (sizeof (Scm ## t) + (l) * sizeof (u) - sizeof (u)))
# define SCM_ALLOC(v,a) MEM_ALLOC (v, MEM_UNITS (a))

# endif
