/* $Id: lmem.c,v 1.1.1.1 2000/05/07 20:26:15 mauhuur Exp $ */
/*
 * $Log: lmem.c,v $
 * Revision 1.1.1.1  2000/05/07 20:26:15  mauhuur
 * Initial import
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "l_defs.h"

#define LPOOLSIZE (sizeof(struct _list)*LPOOLMAX)
#ifdef LP_PACK_BITS
#define LPOOLBITS (LPOOLMAX/8+1)
#define LPSETBIT(p,n) p->bits[n/8]^=(1<<(n%8))
#define LPCHECKBIT(p,n) ((p->bits[n/8]>>(n%8))&1)
#else
#define LPOOLBITS LPOOLMAX
#define LPSETBIT(p,n) p->bits[n]=1-p->bits[n]
#define LPCHECKBIT(p,n) p->bits[n]
#endif

struct _ListsPool {
  uc bits  [LPOOLBITS];
  uc *data;
  ui first;
  ui length;
  ui count;
  struct _ListsPool *next;
};

typedef struct _ListsPool ListsPool;

ListsPool *GlobalListsPool;

ListsPool *NewLPool()
{
  ListsPool *tmp;
  tmp=(ListsPool *)malloc(sizeof(ListsPool));
  memset(tmp->bits,0,LPOOLBITS);
  tmp->first=0;tmp->count=0;
  tmp->data=(uc *)malloc(LPOOLSIZE);
  tmp->length=LPOOLMAX;
  tmp->next=NULL;
  return tmp;
}

int IsInLPool(LIST l,ListsPool *p)
{
  ListsPool *t;
  uc *x=(uc *)l;
  uc *d;
  t=GlobalListsPool;
  do {
    d=t->data;
    if((x>=d) && ((x-d)<LPOOLSIZE)) {p=t;return 1;}
    t=t->next;
  } while(t!=NULL);
  return 0;
}

void LP_lp_free(void *t)
{
  ui n;
  LIST l=(LIST)t;
  ListsPool *p;p=GlobalListsPool;
  if(!IsInLPool(l,p)) {
                printf("Memory error\n");
  		free(t);return;}
  n=((uc *)l-(uc *)p->data)/sizeof(struct _list);
  p->count--;
  LPSETBIT(p,n);
}

/* FIXME: this function needs a great improvement for speed */
ListsPool *CheckPool(ListsPool *p)
{
  ui i,f,n,cf,cn,st;

  if(p->count<LPOOLMAX-10) {
    if(p->length>100) return p;
    f=p->first;n=p->length;
    cf=0;cn=0;st=0;
    for(i=0;i<LPOOLMAX;i++) {
      if(LPCHECKBIT(p,i)) {
	st=1;
	if(cn>n) {n=cn;f=cf;}
      } else {
	if(st) {
	  st=0;
	  cf=i;cn=1;
	} else cn++;
      }
    }
    if(n>p->length) {
      p->length=n;
      p->first=f;
      return p;
    }
  }
  if(p->next!=NULL) {return CheckPool(p->next);}
  p->next=NewLPool();
  return p->next;
}

int IMemVAL=0;

int InitMem(unsigned short int nb)
{
  if(IMemVAL) {
    printf("Sux!\n");
  }
  IMemVAL=1;
#ifndef LP_MALLOC
  GlobalListsPool=NewLPool();
#endif
  return nb;
}

LIST LP_l_alloc_l()
{
  ListsPool *p;
  LIST l;
  p=GlobalListsPool;
  while(p->count>LPOOLMAX-10) {
    if(p->next==NULL) p->next=NewLPool();
    p=p->next;
  }
  if(p->length<2) p=CheckPool(p);
  l=(LIST)(p->data+(sizeof(struct _list)*(p->first)));
  LPSETBIT(p,p->first);
  p->first++;
  p->count++;
  p->length--;
  return l;
}

char *LFreeBuffer[LFREEMAX];
ui   LFreePos=0;

int LP_l_free(char *p)
{
 LFreeBuffer[LFreePos]=p;
 LFreePos++;
 if(LFreePos>LFREEMAX-2) {
   ui i;
   for(i=0;i<LFreePos;i++) free(LFreeBuffer[i]);
   LFreePos=0;
   return 1;
 }
 return 0;
}
