/* message.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: message.cc,v 1.8 2004/10/27 20:40:48 ralf Exp $ */

#include "message.h"
#include "lowlevelfunc.h"
#include "fieldlvrowdata.h"
#include "aguix.h"

Message *AGUIX_allocMessage()
{
  Message *msg;

  msg = (Message*)_allocsafe( sizeof( Message ) );
  memset( msg, 0, sizeof( Message ) );
  msg->specialType = Message::NONE;
  msg->lockElement = NULL;
  msg->ack = false;
  msg->loop = 0;
  msg->keybuf = NULL;
  return msg;
}

void AGUIX_freeMessage( Message *msg )
{
  if ( msg != NULL ) {
    if ( msg->keybuf != NULL ) _freesafe( msg->keybuf );
    _freesafe( msg );
  }
}

AGMessage *AGUIX_allocAGMessage()
{
  AGMessage *agmsg;

  agmsg = (AGMessage*)_allocsafe( sizeof( AGMessage ) );
  agmsg->type = AG_NONE;
  agmsg->key.keybuf = NULL;
  return agmsg;
}

void AGUIX_freeAGMessage( AGMessage *agmsg )
{
  if ( agmsg != NULL ) {
    if ( ( agmsg->type == AG_KEYPRESSED ) || ( agmsg->type == AG_KEYRELEASED ) ) {
      if ( agmsg->key.keybuf != NULL ) _freesafe( agmsg->key.keybuf );
    }
    if ( ( agmsg->type == AG_DND_START ) ||
	 ( agmsg->type == AG_DND_END ) ||
	 ( agmsg->type == AG_DND_CANCEL ) ){
      if ( agmsg->dnd.specialinfo.rowDataP != NULL )
	delete (agmsg->dnd.specialinfo.rowDataP);
    }
    _freesafe( agmsg );
  }
}

AGMessage *AGUIX_allocAGMessage( Message *msg )
{
  AGMessage *agmsg;

  agmsg = AGUIX_allocAGMessage();
  switch( msg->type ) {
    case KeyPress:
      agmsg->type = AG_KEYPRESSED;
    case KeyRelease:
      if ( agmsg->type == AG_NONE ) agmsg->type = AG_KEYRELEASED;
      agmsg->key.window = msg->window;
      agmsg->key.key = msg->key;
      agmsg->key.keystate = msg->keystate;
      agmsg->key.keybuf = dupstring( msg->keybuf );
      break;
    case ButtonPress:
      agmsg->type = AG_MOUSEPRESSED;
    case ButtonRelease:
      if ( agmsg->type == AG_NONE ) agmsg->type = AG_MOUSERELEASED;
      agmsg->mouse.window = msg->window;
      agmsg->mouse.button = msg->button;
      agmsg->mouse.x = msg->mousex;
      agmsg->mouse.y = msg->mousey;
      agmsg->mouse.time = msg->time;
      break;
    case MotionNotify:
      agmsg->type = AG_MOUSEMOVE;
      agmsg->mouse.window = msg->window;
      /* button is wrong -> use queryPointer */
      agmsg->mouse.button = 0;
      agmsg->mouse.x = msg->mousex;
      agmsg->mouse.y = msg->mousey;
      break;
    case Expose:
      agmsg->type = AG_EXPOSE;
      agmsg->expose.window = msg->window;
      agmsg->expose.x = msg->x;
      agmsg->expose.y = msg->y;
      agmsg->expose.w = msg->width;
      agmsg->expose.h = msg->height;
      break;
    case ClientMessage:
      if ( msg->gadgettype == CLOSE_GADGET ) {
        agmsg->type = AG_CLOSEWINDOW;
        agmsg->closewindow.window = msg->window;
      }
      break;
    case EnterNotify:
      agmsg->type = AG_ENTERWINDOW;
    case LeaveNotify:
      if ( agmsg->type == AG_NONE ) agmsg->type = AG_LEAVEWINDOW;
      agmsg->cross.window = msg->window;
      break;
  }
  
  return agmsg;
}
