/* lister.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: lister.h,v 1.13 2004/10/27 21:07:50 ralf Exp $ */

#ifndef LISTER_H
#define LISTER_H

#include "wdefines.h"
#include <X11/X.h>
#include <aguix/aguix.h>
#include <aguix/awindow.h>
#include <aguix/button.h>
#include "datei.h"
#include "dnd.h"

class Worker;
class AGUIX;
class ListerMode;

typedef enum {CYCLICFUNC_MODE_NORMAL,CYCLICFUNC_MODE_FIRSTNULLFT,CYCLICFUNC_MODE_RESTART}
  cyclicfunc_mode_t;

class Lister
{
public:
  Lister(Worker*);
  ~Lister();
  Lister( const Lister &other );
  Lister &operator=( const Lister &other );

  void messageHandler(AGMessage *msg);
  AGUIX *getAGUIX();
  AWindow *getAWindow();
  void setActiveMode(ListerMode*);
  void getGeometry(int*,int*,int*,int*);
  ListerMode *getActiveMode();
  void setFocus(bool);
  bool getFocus();
  void switch2Mode(int);
  void setName(const char*);
  void setStatebarText(const char*);
  void makeActive();
  int getSide();
  bool isActive();
  void configure();
  Worker *getWorker();
  void cyclicfunc(cyclicfunc_mode_t mode);
  int saveState(Datei *fh);
  int loadState();
  int loadBinState(Datei *fh);
  const char *getNameOfMode(int);
  
  void reconfig();
  
  bool startdnd(DNDMsg *dm);
protected:
  Worker *parent;
  AGUIX *aguix;
  AWindow *win;
  Button *lvb;
  ListerMode *activemode;
  int activemodeid;
  ListerMode **modes;
  bool hasFocus;
  int x,y,w,h;
  
  struct timeval lastlvbclick;
};

#endif

