/* nmcacheentry.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NMCACHEENTRY_HH
#define NMCACHEENTRY_HH

#include "wdefines.h"
#include "datei.h"

class NMCacheEntry {
public:
  NMCacheEntry();
  ~NMCacheEntry();
  NMCacheEntry( const NMCacheEntry &other );
  NMCacheEntry &operator=( const NMCacheEntry &other );

  void recalcStats();
  void subentry(FileEntry *fe);
  void next_checkfe();
  void restartcheck();
  void reset_checkfe();
  void checkfordcd();
  void reset_dirsizes();
  void reset_firstnullft();
  void next_firstnullft();
//protected:  // Vorerst public
  Verzeichnis *verz;
  FileEntry *activefe;
  int pos,xpos;
  long files[2];
  loff_t files_s[2];  // Jeweils Insgesamt und selektiert, Bytes gesamt, Bytes
                  // selektiert
  long dirs[2];
  loff_t dirs_s[2];
  FileEntry *checkfe;
  FileEntry *lastfe;  // when this is recognized update the whole listview
  
  int actsortmode;
  int actshowhidden;
  int actfilterlfdnr;
  bool dontcheck;
  FileEntry *firstnullft;
};

#endif

