/* textstoragefile.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005-2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "textstoragefile.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "worker_locale.h"
#include "pdatei.h"

TextStorageFile::TextStorageFile( std::string filename, AWidth &lencalc ) : tss( "", lencalc )
{
  int read_bytes;
  char buffer[ 64 * 1024 ];
  PDatei pd;

  if ( pd.open( filename.c_str() ) == 0 ) {
    read_bytes = pd.read( buffer, sizeof( buffer ) );
    if ( read_bytes >= 0 ) {

      // tab replacing
      std::string notab_buffer;
      
      for ( int i = 0; i < read_bytes; i++ ) {
	if ( buffer[i] != '\t' ) {
	  // ignore \r from dos files
	  if ( buffer[i] != '\r' ) {
	    notab_buffer += buffer[i];
	  }
	} else {
          //TODO currently I replace tabs with 8 spaces
          //  In the future I hope I can make some GUI improvements
          //  so it will not draw tabs but align the next character
          //  at the next tab stop
	  notab_buffer.append( 8, ' ' );
	}
      }

      //      tss = TextStorageString( buffer, read_bytes );
      tss = TextStorageString( notab_buffer, lencalc );
    } else {
      char *tstr = (char*)_allocsafe( strlen( catalog.getLocale( 281 ) ) +
				      strlen( filename.c_str() ) + 1 );
      sprintf( tstr, catalog.getLocale( 281 ), filename.c_str() );
      tss = TextStorageString( tstr, lencalc );
      _freesafe( tstr );
    }
  }
}

int TextStorageFile::getNrOfLines() const
{
  return tss.getNrOfLines();
}

int TextStorageFile::getLine( int line_nr, unsigned int offset, int len, std::string &return_line ) const
{
  return tss.getLine( line_nr, offset, len, return_line );
}

int TextStorageFile::getLine( int line_nr, unsigned int offset, std::string &return_line ) const
{
  return getLine( line_nr, offset, -1, return_line );
}

int TextStorageFile::getMaxLineWidth() const
{
  return tss.getMaxLineWidth();
}

int TextStorageFile::getLineWidth( int line_nr ) const
{
  return tss.getLineWidth( line_nr );
}

void TextStorageFile::setLineLimit( int new_limit )
{
  tss.setLineLimit( new_limit );
}

std::pair<int,int> TextStorageFile::getRealLinePair( int line_nr ) const
{
  return tss.getRealLinePair( line_nr );
}

AWidth &TextStorageFile::getAWidth()
{
  return tss.getAWidth();
}

int TextStorageFile::findLineNr( std::pair<int,int> real_line ) const
{
  return tss.findLineNr( real_line );
}
