/* wckey.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef WCKEY_HH
#define WCKEY_HH

#include "wdefines.h"
#include <aguix/aguix.h>

class WCDoubleShortkey;

class WCKey
{
public:
  List *getDoubleKeys();
  void setDoubleKeys( List *dklist );
  bool hasKey( KeySym k, unsigned int m );
  bool hasKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  void removeKey( KeySym k, unsigned int m );
  void removeKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  void removeKey( WCDoubleShortkey *dk );
  bool conflictKey( KeySym k, unsigned int m );
  bool conflictKey( KeySym k1, unsigned int m1, KeySym k2, unsigned int m2 );
  bool conflictKey( WCDoubleShortkey *dk );
  void addKey( const KeySym k, const unsigned int m );
  void addKey( const KeySym k1, const unsigned int m1, const KeySym k2, const unsigned int m2 );
  void addKey( const WCDoubleShortkey *dk );
protected:
  List *dkeys;    // list of WCDoubleShortkey
  
  void removeAllKeys();
  WCKey();
  virtual ~WCKey();
  WCKey( const WCKey &other );
  WCKey &operator=( const WCKey &other );
};

#endif
