/*
 *  This file is part of x48, an emulator of the HP-48sx Calculator.
 *  Copyright (C) 1994  Eddie C. Dost  (ecd@dressler.de)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* $Log: entriesio.c,v $
 * Revision 1.0  1999/01/11  18:11:25  ecd
 * Initial revision
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>

#include "hp48.h"
#include "global.h"
#include "resources.h"
#include "hp48_emu.h"
#include "entriesio.h"

int
#ifdef __FunctionProto__
read_entries_file(char *name, entries_t *table)
#else
read_entries_file(name, table)
char *name;
entries_t *table,
#endif
{
  struct stat st;
  struct entries_t new;
  FILE *fp;
  unsigned char four[4], label[12];
  int i, k;
  word_20  j , jumpaddr;

  if (NULL == (fp = fopen(name, "r")))
    {
      fprintf(stderr, "can\'t open %s\n", name);
      return 0;
    }

  if (stat(name, &st) < 0)
    {
      fprintf(stderr, "can\'t stat %s\n", name);
      fclose(fp);
      return 0;
    }

  if (fread(four, 1, 4, fp) != 4)
    {
      fprintf(stderr, "can\'t read first 4 bytes of %s\n", name);
      fclose(fp);
      return 0;
    }

  if (fseek(fp, 0, 0) < 0)
    {
      fprintf(stderr, "can\'t fseek to position 0 in %s\n", name);
      fclose(fp);
      return 0;
    }

  k = 0;
  /* Get to the beginning of the Symbol File */ 
  while ( fread(four, 1, 4, fp) && strncmp( "Symb", four ,4 ) )
    fseek(fp, -3, SEEK_CUR);

  /* read label then address */
  while ( fread ( label, 1, 10, fp ) >= 10 )
  {
    if (!strncmp( "Symb", label ,4 ))
      {
        fseek(fp, -6, SEEK_CUR);
      }
    else
      {
        fseek(fp, 2, SEEK_CUR);

        j = 0;
        for (i = 0; i < 6; i++)
         {
            fread ( four,  1, 1, fp );
            j = (j << 8) + four[0];
          }

        strcpy(new.defn, label);
        /* find out what type things are, so we can
           handle breaks properly
         */
        jumpaddr = read_nibbles(j, 5);
        if (jumpaddr == j+5)
          new.rom = j+5;
        else
          new.rom = j;

        table[ k ] = new ;
        k++;
      }
  }

  fclose(fp);

 /*  if (verbose) */
  printf("%s: read %i entries from %s\n", progname, k, name);

  return 1;
}

