/* xdaliclock - a melting digital clock
 * Copyright (c) 1991-2008 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#ifdef USE_IPHONE

# import <Foundation/Foundation.h>
# import <UIKit/UIKit.h>
# define PARENT_CLASS UIView
# define NSRect  CGRect
# define NSColor UIColor

#else  /* !USE_IPHONE */

# import <Cocoa/Cocoa.h>
# define PARENT_CLASS NSView

#endif /* !USE_IPHONE */


#import "xdaliclock.h"


@interface DaliClockView : PARENT_CLASS
{
  dali_config config;

  unsigned char *pixmap;

# ifndef USE_IPHONE
  NSImage *img;
# endif /* !USE_IPHONE */

  NSTimer *clockTimer;
  NSTimer *colorTimer;
  NSTimer *dateTimer;
  CGFloat autoDateInterval;

  BOOL ownWindow;
  BOOL constrainSizes;
  BOOL usesCountdownTimer;
  NSDate *countdownDate;

  NSColor *fg;
  NSColor *bg;
  NSColor *initialForegroundColor;
  NSColor *initialBackgroundColor;
}

#ifndef USE_IPHONE

+ (void)initializeDefaults:(NSUserDefaultsController *)controller;
+ (NSUserDefaultsController *)userDefaultsController;

#endif /* !USE_IPHONE */

- (void)setOwnWindow:(BOOL)own_p;
- (void)setConstrainSizes:(BOOL)constrain_p;
- (void)setAutoDate:(CGFloat)interval;
- (IBAction) aboutClick: (id)sender;

// Start timers
- (void)clockTick;
- (void)colorTick;
- (void)dateTick;


/* Bindable Properties:
     hourStyle
     timeStyle
     dateStyle
     cycleSpeed
     usesCountdownTimer
     countdownDate
     initialForegroundColor
     initialBackgroundColor
*/

@end
