.TH indiserver 1
.SH NAME
indiserver \- provide socket access to one or more local or remote INDI drivers
.SH SYNOPSIS
\fBindiserver [options] driver [driver ...]\fP
.SH DESCRIPTION
.na
.nh
.PP
indiserver is a TCP server that provides network access to any number of local
INDI Driver programs or INDI Devices running on other indiservers in a
chained fashion.
.SH OPTIONS
.TP 8
-l
enables logging all driver packets that contain messages. Each log entry
consists of the timestamp, the device and the message. The logs are files
created in the given directory. The log file is named from the date portion
of the timestamp. Thus a new log file is created each day.
.TP
-p \fIp\fP
specifies that the indiserver listen to port p, instead of the default
standard INDI port of 7624.
.TP
-r \fIn\fP
specifies that indiserver should to restart a local driver that exits
unexpectedly a maximum of n times; the default is 10. Remote connections are
never restarted but cause indiserver to exit immediately.
.TP
-v
arranges for additional trace information to be printed to stderr. These are
cumulative. One (-v) reports each client connect and disconnect. Two (-vv)
adds key information about each message being sent or received in the form of
the client channel or device name; the toplevel INDI XML element; the device,
property name, state, perm and message attributes as appropriate; then the
name and value of each array member of the INDI element. Three (-vvv) adds the
complete XML message.
.SH DRIVER
Each additional argument
can be either the name of a local program to run or a specification of an
INDI Device on a remote indiserver.
.PP
A local program is specified as the path name of the execuble to run (not the
name of the Device it implements).
The program is presumed to implement the INDI 
protocol on its stdin and stdout channels to implement exactly one Device.
The program may send ad-hoc out-of-band error or trace messages to its stderr,
each line of which will be prefixed with the name of the Device and a timestamp
then is merged in with the indiserver's stderr.
.PP
A remote Device is given in the form
device@host[:port], where device is the INDI device already available on
another running instance of indiserver, host is the TCP host name on which
said instance is running and the optional port is the port on which to connect
if other than the standard port 7624. Again, remote connections specify the
name of the Device, irrespective of the name of its local driver program.

.SH EXIT STATUS
indiserver is intended to run forever and so never exits normally. If it
does exit, it prints a message to stderr and exits with status 1.

.SH EXAMPLES
In the following discussion, suppose there are driver programs named cam,
security, ota and tmount which implement INDI devices Camera, Security, OTA and
Mount, respectively.
.PP
Remote indiserver connections are useful in several scenarios. One possibility
is to allow Drivers to run on platforms most appropriate to the hardware
they are controlling and yet be combined with Devices on other platforms.
For example, suppose a camera device requires a special hardware connection
and dedicated processing so its driver is run on host1. Other devices are
simpler and can be run on host2. In this case, the camera device might be run
as follows (the prompt denotes the host name):
.IP
host1: indiserver cam
.PP
and combined with other drivers as follows:
.IP
host2: indiserver Camera@host1 ota tmount
.PP
In this way an INDI client connecting to host2 seemlessly sees all the devices
Camera, OTA and Mount.
.PP
Another situation is to manage which Devices are available to
connecting INDI clients depending on how they connect.
Suppose a third indiserver is started as follows:
.IP
host2: indiserver -p 7625 security Camera@host1 OTA@host2 Mount@host2
.PP
An INDI client connecting to port 7625 on host2 will now also see the
Security device in addition to the other devices (presumably this port
would be hidden by firewall technology).

.SH SEE ALSO
.PP
evalINDI, getINDI, setINDI, indidevapi
.br
http://www.clearskyinstitute.com/INDI/INDI.pdf.
