.TH setINDI 1
.SH NAME
setINDI \- set one or more writable INDI property values
.SH SYNOPSIS
\fBsetINDI [options] device.property.e1[;e2...]=v1[;v2...] ... \fP

.SH DESCRIPTION
.na
.nh
.PP
setINDI connects to an indiserver and sends commands to set new values for
specified properties. Each property is specified using three components 
followed by the new value in the following form:
.IP
device.property.element=value
.PP
Since in element may be an array, the syntax allows for multiple elements
for one property to be specified separated by semicolons, and the value to
have an equal number of components also separated by semicolons. When
specified in this manner, all elements are updated atomically.

.SH OPTIONS
.TP 8
-d <f>
use file descriptor f already open as a socket to the indiserver. This is
useful for scripts to make a session connection one time then reuse it for
each invocation. If the file descriptor seems to be being closed, check that
the close-on-exec flag is off; for example in perl use something like:
.nf

#!/usr/bin/perl
use Socket;
use Fcntl;
socket(SOCK, PF_INET, SOCK_STREAM, getprotobyname('tcp'));
connect(SOCK, sockaddr_in(7624,inet_aton('localhost')));
fcntl(SOCK,F_SETFD,0);
$directfd = fileno(SOCK);
&runindi ("./setINDI", "-d", "$directfd", "x.y.z=10");
&runindi ("./setINDI", "-d", "$directfd", "a.b.c=hello");
sub runindi { if (fork()) { wait(); } else { exec @_; } }
.fi

.TP
-h <h>
connect to alternate host h; the default is localhost.
.TP
-p <p>
connect using alternate port p; the default is 7624.
.TP
-t <t>
wait no longer than t seconds to accomplish setting the new values; the
default is 2 seconds.
.TP
-v
generate additional information on stderr.

.SH EXIT STATUS
The setINDI program exits with a status of 0 if it suceeded in setting the
new value for each specified property. It exits with 1 if there was at least
one property for which a value could not be set within the given timeout period.
It exits with 2 if there was some other error such as not being able to
connect to the indiserver.

.SH EXAMPLES
.PP
Send new lat/long location values atomically to the Mount driver:
.IP
setINDI 'Mount.Location.Latitude;Longitude=30;100'

.SH SEE ALSO
.PP
evalINDI, getINDI, indiserver
.br
http://www.clearskyinstitute.com/INDI/INDI.pdf
