/*  xhangglider
 *  Copyright (C) 1999 Yasuhiro Take
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __DEF_H
#define __DEF_H

#ifndef DEFAULT_DATA_PATH
#define DEFAULT_DATA_PATH "/usr/share/xhangglider"
#endif

#define myTRUE 1
#define myFALSE 0

#define PLANE_YZ 0
#define PLANE_ZX 1
#define PLANE_XY 2

#define LIMIT_POSITIVE 1.0
#define INVALID_VALUE 1.0

#define DIM_X 0
#define DIM_Y 1
#define DIM_Z 2

#define SORT_DIRECTION_MAX_FIRST -1
#define SORT_DIRECTION_MIN_FIRST 1

#define T_QUAD 4
#define T_TRI 3
#define T_LINE 2
#define T_BALL 1
#define T_UNUSED 0

#define DRAW_NORMAL 0
#define DRAW_NOFLICKER 1
#define DRAW_USECLIP 2

typedef struct {
  float distance;
  float vertix[4][4];
  char name[20];
  union {
    char name[20];
    unsigned int pixel;
  } color;
  int type;
} Polygon;

typedef struct {
  Polygon *pol;
  int n_pol;
} PolygonData;

typedef struct {
  double x, y, z;
} Vector;

#endif
