;
; FM-7 EMULATOR "XM7"
;
; Copyright (C) 1989,2000 ohD(ytanaka@ipc-tokai.or.jp)
; [ FM-TOWNS AZuTu ]
;

	%ifdef FMT

		segment	_data public align=2 class=DATA
		extern	_vram_c
		extern	_timer_flag
		extern	_opn_reg
		extern	_opn_scale
		segment	_fmt_sub_text public align=1 class=CODE
		global	_vram_setb
		global	_vramoff_setw
		global	_opn_setb
		global	_timer_init
		global	_timer_cleanup
		global	_joy_getb

;
; uq`l
;
_vram_setb:
		push	bp
		mov	bp,sp
		mov	ax,[bp+6]
		mov	bl,01h
		cmp	ax,4000h
		jc	.ok
		add	bl,bl
		cmp	ax,8000h
		jc	.ok
		add	bl,bl
.ok:
		and	ax,3fffh
		mov	cx,0c000h
		mov	es,cx
		mov	[es:0ff81h],bl

		mov	bh,80
		div	bh
		mov	bl,ah
		xor	bh,bh
		mov	dh,160
		mul	dh
		add	bx,ax
		mov	ax,[bp+8]
		mov	[es:bx],al
		pop	bp
		retf

;
; uq`lItZbgWX^ݒ
;
_vramoff_setw:
		pushf
		push	si
		push	di
		push	ds
		cld
		mov	si,[_vram_c]
		mov	ax,[_vram_c+2]
		mov	ds,ax

		mov	ax,0c000h
		mov	es,ax
		mov	byte [es:0ff81h],01h
		xor	di,di
		mov	bl,200
.blue:
		mov	cx,40
		rep	movsw
		add	di,80
		dec	bl
		jnz	.blue

		add	si,384

		mov	byte [es:0ff81h],02h
		xor	di,di
		mov	bl,200
.red:
		mov	cx,40
		rep	movsw
		add	di,80
		dec	bl
		jnz	.red

		add	si,384

		mov	byte [es:0ff81h],04h
		xor	di,di
		mov	bl,200
.green:
		mov	cx,40
		rep	movsw
		add	di,80
		dec	bl
		jnz	.green

		pop	ds
		pop	di
		pop	si
		popf
		retf

;
; OPN
;
_opn_setb:
		retf

;
; ^C}|荞
;
timer_entry:
		pushf
		cli
		push	ax
		push	ds
		mov	ax,seg _timer_flag
		mov	ds,ax
		mov	al,01h
		mov	[_timer_flag],al
		pop	ds
		pop	ax
		popf
		retf

;
; ^C}| ZbgAbv
;
_timer_init:
		push	ds
		xor	al,al
		mov	[_timer_flag],al
		mov	ax,cs
		mov	ds,ax
		mov	[timer_svr_seg],ax
		mov	di,timer_svr
		xor	ah,ah
		int	97h
		pop	ds
		mov	[cs:timer_id],al
		retf

;
; ^C}| N|Abv
;
_timer_cleanup:
		mov	al,[cs:timer_id]
		mov	ah,01h
		int	97h
		retf

;
; WCXeBbNǂݎ
;
_joy_getb:
		push	bp
		mov	bp,sp
; ݃`FbN
		in	al,30h
		and	al,0f8h
		jnz	.fmr
; COM=0,TRIG=1
		mov	al,0fh
		mov	dx,04d6h
		out	dx,al
; ǂݎ
		mov	ax,[bp+6]
		and	ax,0001h
		add	ax,ax
		mov	dx,04d0h
		add	dx,ax
		in	al,dx
; COM0łȂ΃G|
		test	al,40h
		jnz	.fmr
		not	al
		and	ax,003fh
		pop	bp
		retf
; FM-R
.fmr:
		xor	ax,ax
		pop	bp
		retf

;
; ^C}| |NGA
;
timer_id:
		db	0
timer_svr:
		dw	0
		dw	timer_entry
timer_svr_seg:
		dw	0
		dw	0
		dw	1

	%endif
		end
