/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ IBM-PC ʃTu[` ]
 */

#if defined(__MSDOS__) && defined(IBM)

#include <assert.h>
#include <dos.h>
#include <string.h>
#include "xm7.h"
#include "device.h"
#include "ibm.h"

/*
 *	X^eBbN [N
 */
static BYTE scr_vmode;					/* rfI[h */

/*
 *	fW^pbge[u
 */
const BYTE palet_table[] = {
	0x00, 0x00, 0x00,
	0x35, 0x00, 0x00,
	0x00, 0x35, 0x00,
	0x35, 0x35, 0x00,
	0x00, 0x00, 0x35,
	0x35, 0x00, 0x35,
	0x00, 0x35, 0x35,
	0x35, 0x35, 0x35
};

/*
 *	ʕ\ 
 */
void scr_init(void)
{
	union REGS regs;
	int i;
	BYTE far *p;

	/* rfI[h擾 */
	regs.h.ah = 0x0f;
	int86(0x10, &regs, &regs);
	scr_vmode = regs.h.al & 0x7f;

	/* rfI[hݒ */
	/* mode 0E (640x200x4bpp, EGA) */
	regs.x.ax = 0x000e;
	int86(0x10, &regs, &regs);

	/* CPUVRAMANZX */
	regs.x.ax = 0x1200;
	regs.h.bl = 0x32;
	int86(0x10, &regs, &regs);

	/* EGAWX^ݒ */
	outpw(0x3ce, 0x0801);
	outpw(0x3ce, 0x0005);
	outpw(0x3ce, 0x0003);
	outpw(0x3ce, 0x0002);

	/* v[SNA */
	outpw(0x3c4, 0x0802);
	p = (BYTE far *)(0xa0000000L);
	memset(p, 0, 640 * 200);

	/* pbgݒ(DACe[u0`15ɑΉÂ) */
	for (i=0; i<8; i++) {
		regs.h.bh = i;
		regs.h.bl = i;
		regs.h.ah = 0x10;
		regs.h.al = 0;
		int86(0x10, &regs, &regs);
	}
}

/*
 *	ʕ\ N[Abv
 */
void scr_cleanup(void)
{
	union REGS regs;

	/* rfI[h𕜌 */
	regs.h.ah = 0;
	regs.h.al = scr_vmode;
	int86(0x10, &regs, &regs);
}

/*
 *	uq`lPoCg
 */
void vram_setb(WORD addr, BYTE dat)
{
	BYTE far *p;

	p = (BYTE far *)(0xa0000000L);

	/* v[ZNg */
	if (addr < 0x4000) {
		outpw(0x3c4, 0x0102);
	}
	else {
		if (addr < 0x8000) {
			outpw(0x3c4, 0x0202);
		}
		else {
			outpw(0x3c4, 0x0402);
		}
	}
	addr &= 0x3fff;

	/*  */
	p[addr] = dat;
}

/*
 *	fW^pbgݒ
 */
void ttlpalet_setb(int no, BYTE dat)
{
	disable();
	outp(0x3c8, no);
	outp(0x3c9, palet_table[dat * 3 + 1]);
	outp(0x3c9, palet_table[dat * 3 + 2]);
	outp(0x3c9, palet_table[dat * 3 + 0]);
	enable();
}

/*
 *	uq`lItZbgWX^ݒ
 */
void vramoff_setw(WORD offset)
{
	BYTE far *p;
	BYTE far *q;

	q = (BYTE far*)(0xa0000000L);

	p = &vram_c[0];
	outpw(0x3c4, 0x0102);
	memcpy(q, p, 16000);

	p = &vram_c[0x4000];
	outpw(0x3c4, 0x0202);
	memcpy(q, p, 16000);

	p = &vram_c[0x8000];
	outpw(0x3c4, 0x0402);
	memcpy(q, p, 16000);
}

void keyboard_setled(void)
{
}


#endif	/* __MSDOS__ && IBM */
