/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ IBM-PC t@CI/O ]
 */

#if defined(__MSDOS__) && defined(IBM)

#include <assert.h>
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include "xm7.h"
#include "device.h"

/*
 *	t@Cǂݏo
 */
BOOL file_load(char *fname, BYTE *buf, int size)
{
	int handle;

	handle = _open(fname, O_BINARY);
	if (handle == -1) {
		return FALSE;
	}

	if (_read(handle, buf, size) != size) {
		_close(handle);
		return FALSE;
	}

	_close(handle);
	return TRUE;
}

/*
 *	t@CI[v
 */
int file_open(char *fname, int mode)
{
	switch (mode) {
		case OPEN_R:
			return _open(fname, O_BINARY |  O_RDONLY);
		case OPEN_W:
			return open(fname, O_BINARY | O_CREAT | O_WRONLY, S_IWRITE);
		case OPEN_RW:
			return _open(fname, O_BINARY | O_RDWR);
	}

	return -1;
}

/*
 *	t@CN[Y
 */
void file_close(int handle)
{
	_close(handle);
}

/*
 *	t@CTCY擾
 */
DWORD file_getsize(int handle)
{
	long now;
	long end;

	now = tell(handle);
	if (now == -1) {
		return 0;
	}

	end = lseek(handle, 0L, SEEK_END);
	lseek(handle, now, SEEK_SET);

	return end;
}

/*
 *	t@CV[N
 */
BOOL file_seek(int handle, DWORD offset)
{
	DWORD now;

	now = (DWORD)lseek(handle, offset, SEEK_SET);
	if (now != offset) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@Cǂݏo
 */
BOOL file_read(int handle, BYTE *ptr, DWORD size)
{
	DWORD cnt;

	cnt = (DWORD)_read(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	t@C
 */
BOOL file_write(int handle, BYTE *ptr, DWORD size)
{
	DWORD cnt;

	cnt = (DWORD)_write(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}


#endif	/* __MSDOS__ && IBM */
