/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 Toshio ISHIZAKA(vh6t-iszk@asahi-net.or.jp)
 *	[ X Window System screen draw ]
 */
/*
  X Window System related version info.
  v0.1  199909??  worked w/ Pixmap
  v0.2  19990920  worked w/ XImage
  v0.3  19991005  worked w/ XShm (also support XImage)
  v0.4  19991009  __asm__ instead of XPutPixel (also work XPutPixel)
  v0.5  19991014  redraw workaround, many speedups
  v0.51 19991016  __asm__ workaround
  v0.52 19991017  __asm__ workaround, scroll slightly speedup
  v0.53 20000124  do_events() come here in xw_disp.c
  v0.60	20000210  interval-timer driven event handler
 */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <string.h>
#include <sys/time.h>
#include <sys/errno.h>
/**/
#include <X11/extensions/XShm.h>
#ifdef __FreeBSD__
#include <machine/param.h>
#endif
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>
/**/
#include "xm7.h"
#include "keyboard.h"
#include "xw.h"
#include "gui.h"
#include "subctrl.h"

#define XSIZE 640
#define YSIZE 400

Display *dpy;
Screen *scr;
Window win;
Widget w;
XImage *img;
char *imgval, *imgtmp, *buf;
GC gc;
unsigned long palette[8], red_mask, green_mask, blue_mask;
int pseudoColor, depth;
int use_xshm = 0;
int (*prev_err_handler)(Display *);
extern WORD vram_offset;
int redraw_flag=False, pal_flag=False; /* display update flags */
BYTE lineflag[YSIZE];
int focus_flag=False;
int timer_flag=FALSE;
int disp_timer;
int oldkey = -1;
static BYTE nmi_timer;/* NMI timer */
XShmSegmentInfo shminfo;

/*
 recalc img from imgval, with palette
 */

void
recalc_img(void){
	int addr=0, x, y;
	for( y = 0 ; y < YSIZE ; y+=2 ){
		switch( depth ){
#if defined(__i386__)
		case 15:
		case 16:
			for( x = 0 ; x < XSIZE; x+=8 ) {
				__asm__ ("
		pushl %0
		pushl %2
		popl %%edi
		popl %%esi
		movl %1,%%ebx

		movzbl (%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,(%%edi)
		movzbl 1(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,2(%%edi)
		movzbl 2(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,4(%%edi)
		movzbl 3(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,6(%%edi)
		movzbl 4(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,8(%%edi)
		movzbl 5(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,10(%%edi)
		movzbl 6(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,12(%%edi)
		movzbl 7(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,14(%%edi)" : : 
		"g"(&(imgval[addr])),	/* %0 <= &imgval[] */
		"g"(&palette),		/* %1 <= palette */
		"g"((img->data)+(y*(img->bytes_per_line)+x*2))	/* %2 <= v */
		: "ax","bx","si","di" );
				addr+=8;
			}
			break;
		case 8:
			for( x = 0 ; x < XSIZE; x+=8 ) {
				__asm__ ("
		pushl %0
		pushl %2
		popl %%edi
		popl %%esi
		movl %1,%%ebx

		movzbl (%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,(%%edi)
		movzbl 1(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,1(%%edi)
		movzbl 2(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,2(%%edi)
		movzbl 3(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,3(%%edi)
		movzbl 4(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,4(%%edi)
		movzbl 5(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,5(%%edi)
		movzbl 6(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,6(%%edi)
		movzbl 7(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%ax,7(%%edi)" : : 
		"g"(&(imgval[addr])),	/* %0 <= &imgval[] */
		"g"(&palette),		/* %1 <= palette */
		"g"((img->data)+(y*(img->bytes_per_line)+x))	/* %2 <= v */
		: "ax","bx","si","di" );
				addr+=8;
			}
			break;
#endif
		default: {
				for( x= 0 ; x < XSIZE ; x++ ){
					XPutPixel( img, x, y, palette[imgval[addr]] );
					addr++;
				}
			}
		}
	}
//	pal_flag = False;
}

/*
 * redraw all from img
 */

void
redraw_all(void){
	int y;
    
	for( y = 0 ; y < YSIZE ; y+=2 ){
		if( pal_flag || lineflag[y] ){ // new!
			if( use_xshm ){
				XShmPutImage( dpy, win, gc, img, 0,y, 0,y, XSIZE,1, False );
			}else{
				XPutImage( dpy, win, gc, img, 0,y, 0,y, XSIZE,1 );
			}
		}
	}
    
	redraw_flag = False;
	pal_flag = False;
	bzero( lineflag, YSIZE );	// new!
	XFlush( dpy );
}

/*
 * redraw specified byte
 */

void
redraw_byte(WORD addr){
	int x,y, bufaddr;

	addr &= 0x3fff;
	/* update imgval, based on vram_c */
	{
#ifdef __i386__
		__asm__ __volatile__ ("
		movl %0,%%esi
		movl %1,%%edi
		
		movb 0x8000(%%esi),%%ah
		movb 0x4000(%%esi),%%bl
		movb (%%esi),%%bh
		
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,1(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,2(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,3(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,4(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,5(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,6(%%edi)
		xorb %%al,%%al
		shlb $1,%%ah
		rclb $1,%%al
		shlb $1,%%bl
		rclb $1,%%al
		shlb $1,%%bh
		rclb $1,%%al
		movb %%al,7(%%edi)" : : 
		"g"(&(vram_c[addr])),		/* %0 <= &vram_c[] */
		"g"(&(imgval[addr*8]))		/* %1 <= &imgval[] */
		: "ax","bx","si","di" );
#else
		register unsigned char m, xd;
		bufaddr = addr*8;
		for( xd=0; xd<8; xd++ ){
			imgval[ bufaddr+xd ]=
				((vram_c[addr       ]&m)?1:0)+
				((vram_c[addr+0x4000]&m)?2:0)+
				((vram_c[addr+0x8000]&m)?4:0);
			m >>= 1;
		}
#endif
	}
	/* redraw, based on imgval */
	bufaddr = addr*8;
	x = (addr%80)*8;
	y = (addr/80)*2;

	if( y < YSIZE ){
		switch( depth ){
#ifdef __i386__
		case 15:
		case 16:
			__asm__ ("
		movl %2,%%edi
		movl %0,%%esi
		movl %1,%%ebx
		
		movzbl (%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,(%%edi)
		movzbl 1(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,2(%%edi)
		movzbl 2(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,4(%%edi)
		movzbl 3(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,6(%%edi)
		movzbl 4(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,8(%%edi)
		movzbl 5(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,10(%%edi)
		movzbl 6(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,12(%%edi)
		movzbl 7(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movw %%ax,14(%%edi)" : : 
		"g"(&(imgval[bufaddr])),/* %0 <= &imgval[] */
		"g"(&palette),		/* %1 <= palette */
		"g"((img->data)+(y*(img->bytes_per_line)+x*2))	/* %2 <= v */
		: "ax","bx","si","di" );
			break;
		case 8:
			__asm__ ("
		movl %2,%%edi
		movl %0,%%esi
		movl %1,%%ebx
		
		movzbl (%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,(%%edi)
		movzbl 1(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,1(%%edi)
		movzbl 2(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,2(%%edi)
		movzbl 3(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,3(%%edi)
		movzbl 4(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,4(%%edi)
		movzbl 5(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,5(%%edi)
		movzbl 6(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,6(%%edi)
		movzbl 7(%%esi),%%eax
		movl (%%ebx,%%eax,4),%%eax
		movb %%al,7(%%edi)" : : 
		"g"(&(imgval[bufaddr])),/* %0 <= &imgval[] */
		"g"(&palette),		/* %1 <= palette */
		"g"((img->data)+(y*(img->bytes_per_line)+x))	/* %2 <= v */
		: "ax","bx","si","di" );
			break;
#endif
		default: {
				register unsigned char xd, t;
			
				for( xd=0; xd<8; xd++ ){
					XPutPixel( img, x+xd, y, palette[imgval[bufaddr]] );
					bufaddr++;
				}
				break;
			}
		}
		lineflag[y] = TRUE;	// new!
		redraw_flag = True;
    }
}

void
handle_event( XEvent *ev ){
    switch ( ev->type ){
/*
	case KeyPress:
		key_down(((XKeyEvent *)ev)->keycode);
		break;
	case KeyRelease:
		key_up(((XKeyEvent *)ev)->keycode);
		break;
*/
    case Expose:
        {
			int x = ((XExposeEvent *)ev)->x, y = ((XExposeEvent *)ev)->y;
			if( use_xshm ){
				XShmPutImage( dpy, win, gc, img, x,y, x,y, 
							  ((XExposeEvent *)ev)->width,
							  ((XExposeEvent *)ev)->height,
							  False );
			}else{
				XPutImage( dpy, win, gc, img, x,y, x,y, 
						   ((XExposeEvent *)ev)->width,
						   ((XExposeEvent *)ev)->height );
			}
		}
	break;
    case FocusIn:
		if( focus_flag == False ){
			focus_flag = True;
/*			printf("focus-in\n");*/
		}
		break;
    case FocusOut:
		if( focus_flag == True ){
			XKeyboardControl kbd_restore;
			focus_flag = False;
/*			printf("focus-out\n");*/
		}
		break;
    case ClientMessage:
		if( (((XClientMessageEvent *)ev)->message_type 
			 == XInternAtom( dpy, "WM_PROTOCOLS", False )) &&
			(((XClientMessageEvent *)ev)->data.l[0]
			 == XInternAtom( dpy, "WM_DELETE_WINDOW", False ))) {
			printf("got WM_DELETE_WINDOW\n");
			stopreq_flag = TRUE;
		}
		break;
    default:
		printf("unknown event %d\n", ev->type);
    }
}

int
get_image( void ){
	use_xshm = FALSE;
	if( !no_shm && XShmQueryExtension( dpy ) ){
		int major, minor;
		Bool pixmaps;
		
		if(XShmQueryVersion(dpy, &major, &minor, &pixmaps) == True) {
			use_xshm = TRUE;
			printf( "XSHM extension (v%d.%d) detected.\n", major, minor );
		}
    }
    if( use_xshm ){
		img = XShmCreateImage(dpy, DefaultVisualOfScreen(scr),
							  DefaultDepthOfScreen(scr),
							  ZPixmap, NULL, &shminfo,
							  XSIZE, YSIZE );	
		if(img == NULL){
			printf("some error in XShmCreateImage\n");
			goto no_xshm;
		}
		shminfo.shmid = shmget( IPC_PRIVATE,
								img->bytes_per_line*img->height,
								IPC_CREAT | 0777 );
		if(shminfo.shmid < 0){
			printf("error in shmget: %s\n", strerror( errno ));
			goto no_xshm;
		}
		shminfo.shmaddr = img->data = (char *)shmat(shminfo.shmid, 0, 0);
		if(shminfo.shmaddr == (char *) -1){
			printf("error in shmat: %s\n", strerror( errno ));
			goto no_xshm;
		}
		shminfo.readOnly = False;
		XShmAttach(dpy, &shminfo);
		buf = NULL;
		printf("Using XSHM(shmid=%d).\n", shminfo.shmid );
    }else{
    no_xshm:
		use_xshm = FALSE;
    }
    if( !use_xshm ){
		printf("Using normal XImage, maybe slow...\n");
		buf = (char *)malloc( XSIZE * YSIZE * sizeof(long));
		bzero( buf, XSIZE * YSIZE * sizeof(long));
		img = XCreateImage( dpy, DefaultVisualOfScreen(scr),
							DefaultDepthOfScreen(scr), ZPixmap, 0,
							buf, XSIZE, YSIZE, 8, 0);
    }
}

void
xwin_cleanup(){
	XDestroyWindow( dpy, win );
	XFlush(dpy);
	if( use_xshm ){
		/* XShm dispose */
		XShmDetach( dpy, &shminfo );
	}
	XDestroyImage( img );
	if( use_xshm ){
		/* shm dispose */
		struct shmid_ds shmid_buf;
		
		if( shmdt(shminfo.shmaddr) < 0 ){
			printf("error in shmdt: %s\n", strerror( errno ));
		}
		if( shmctl(shminfo.shmid, IPC_RMID, &shmid_buf ) < 0 ){
			printf("error in shmctl(RMID): %s\n", strerror( errno ));
		}
	}
}


int
fatal_xwin_err_handler( Display *dpy ){
	printf("Fatal error recieved!\n");
	xwin_cleanup();
	prev_err_handler( dpy );
	/* this handler make process terminate, so this is last resort */
}

void 
timer_event( int sig ){
	XEvent ev;
	
	/* process only when running */
	if( !run_flag ){
		return;
	}
	if( stopreq_flag ){
		run_flag = FALSE;
		return;
	}
	
	/* re-entrant check */
	if( timer_flag ){
//		printf("!!\n");
		return;
	}else{
		timer_flag = TRUE;
	}
	
	/* message pump, with key-repeat cancellation */
	while( XPending( dpy )!= 0 ){
		unsigned int newkey;
		XEvent *evp = &ev;
		
		XNextEvent( dpy, &ev );
		newkey = ((XKeyEvent *)evp)->keycode;
		switch( ev.type ){
		case KeyPress:
			if ( newkey == 37 ){ /* special handling for CapsLock */
				key_up( newkey );
			}
			if ( oldkey != newkey ){
				key_down(newkey);
			}else{
				oldkey = -1;
			}
			break;
		case KeyRelease:
			if ( oldkey != -1 ){
				key_up( oldkey );
			}
			oldkey = newkey;
			if( newkey == 37 ){ /* special handling for CapsLock */
				key_up( newkey );
				key_down( newkey );
				oldkey = -1;
			}
			break;
		default:
			handle_event( &ev );
		}
	}
	if( oldkey != -1 ){
		key_up(oldkey);
		oldkey = -1;
	}
	
	
	if( !gui_flag ){
		/* NMI */
		nmi_timer++;
		if (nmi_timer >= 2) {
			subcpu_nmi();
			nmi_timer = 0;
		}
		
		/* IRQ, sound */
		mainetc_timer();
		snd_timer();

		/* execute VM */
		while( maincpu.total < cpu_speed ) {
			int i;
			for( i = 0; i < 128; i++ ) {
				maincpu_exec();
				if( !subhalt_flag ) {
					subcpu_exec();
				}
			}
		}
		maincpu.total -= cpu_speed;
	}
	/* redraw */
	disp_timer++;
	if( disp_timer >= 3 ){
		disp_timer = 0;
		if( redraw_flag == True ){
			if( pal_flag == True ){
				recalc_img();
			}
			redraw_all();
	    }
	}
	timer_flag = FALSE;
}

void
xwin_init( int *argc, char **argv ){
    Window root;
    Widget toplevel;
    unsigned long black,white;
    int i;

    /* process argument */
    toplevel=XtInitialize(argv[0], "xm7", NULL, 0, argc, argv );
/*    XtGetApplicationResources(toplevel,NULL,NULL,0,NULL,0);*/
    dpy = XtDisplay( toplevel );
    scr = XtScreen( toplevel );
    root= RootWindowOfScreen( scr );
    black=BlackPixelOfScreen( scr );
    white=WhitePixelOfScreen( scr );
    depth = DefaultDepthOfScreen( scr );
    
    /* check colormap */
    pseudoColor = ( (DefaultVisualOfScreen(scr)->class) == PseudoColor );
    if( pseudoColor ){
	printf( "using pseudoColor method....\n" );
	if(!XAllocColorCells(dpy,DefaultColormapOfScreen(scr),
			     False,NULL,0,palette,8)){
	    fputs("cannot alloc colormap entries.\n",stderr);
	    exit(1);
	}
    }else{
	Visual *v;
	v = DefaultVisualOfScreen(scr);
	blue_mask  = v->blue_mask;
	red_mask   = v->red_mask;
	green_mask = v->green_mask;
    }
    
    /* create window */
    win=XCreateSimpleWindow( dpy, DefaultRootWindow(dpy), 
			     0,0, XSIZE,YSIZE, 0,black,black);
    {
		/* fixize window size */
		XSizeHints hints;
		hints.width =  hints.max_width  = hints.min_width  = XSIZE;
		hints.height = hints.max_height = hints.min_height = YSIZE;
		hints.flags =  USSize | PMaxSize | PMinSize ;
		XSetNormalHints( dpy, win, &hints);
    }
    XSelectInput( dpy, win, 
		  ExposureMask|KeyReleaseMask|KeyPressMask|FocusChangeMask );
    XClearWindow( dpy, win );
    XStoreName( dpy, win, "XM7");
    XMapWindow( dpy, win );
    
    /* create gc */
    gc = XCreateGC( dpy, DefaultRootWindow(dpy), NULL, NULL );
    XSetFunction( dpy, gc, GXcopy );
    XSetForeground( dpy, gc, 0 );
    XSetGraphicsExposures(dpy,gc,False);
    XFlush(dpy);
    
    /* set error handler */
    prev_err_handler = XSetIOErrorHandler( fatal_xwin_err_handler );
    
    /* check XShm and allocate image */
    get_image();
    
    {
	/* workaround(?) for WM_PROTOCOLS */
		Atom props[2];
		int i = 0;
		props [i++] = XInternAtom (dpy, "WM_DELETE_WINDOW", False);
		XChangeProperty (dpy, win,
						 XInternAtom (dpy, "WM_PROTOCOLS", False),
						 XA_ATOM, 32, PropModeAppend,
						 (unsigned char *) props, i);
    }
	/* initialize work */
	bzero( lineflag, YSIZE );	// new!
	run_flag = TRUE;
	stopreq_flag = FALSE;
	timer_flag = FALSE;
}


/* [ external interface ] ------------------------------------------------ */

int
timer_init(void){
	struct itimerval itimer;
	
	signal( SIGALRM, timer_event );
	itimer.it_interval.tv_sec  = itimer.it_value.tv_sec  = 0;
	itimer.it_interval.tv_usec = itimer.it_value.tv_usec = 10000;
	setitimer( ITIMER_REAL, &itimer, NULL );
}

int
disp_init(int *argc, char **argv){
    xwin_init( argc, argv );
    
    imgval = (char *)malloc(0x4000*8);
    imgtmp = (char *)malloc(0x4000*8);
    
    if ((imgval == NULL)||(imgtmp == NULL)){
		return FALSE;
    }

    return TRUE;
}

void
disp_cleanup(void){
    xwin_cleanup();
    free( imgval );
    free( imgtmp );
}

void
vram_setb(WORD addr, BYTE dat){
    redraw_byte(addr);
}

void
ttlpalet_setb(int no, BYTE dat){
    XColor xc;
    
    if( pseudoColor ){
		xc.pixel=palette[no];
		xc.blue  = (dat&1) ? 65535 : 0;
		xc.red   = (dat&2) ? 65535 : 0;
		xc.green = (dat&4) ? 65535 : 0;
		xc.flags = DoRed|DoGreen|DoBlue;
		xc.pad   = 0;
		XStoreColor(dpy,DefaultColormapOfScreen(scr),&xc);
    }else{
		unsigned long t=0;
	
		if(dat&1) t|=blue_mask;
		if(dat&2) t|=red_mask;
		if(dat&4) t|=green_mask;
		palette[no]=t;
		redraw_flag = pal_flag = True;
    }
}

void
vramoff_setw(WORD offset){
    int ofs;
    
    /* move imgval */
    ofs = (offset & 0x3fe0) * 8;
    memcpy(imgtmp, imgval, ofs);
    memcpy(imgval, (imgval + ofs), 0x4000 * 8 - ofs);
    memcpy(imgval + (0x4000 * 8 - ofs), imgtmp, ofs);
    
    /* VRAM contents are already modifyed, so simply redraw */
    redraw_flag = pal_flag = True;
}


void
keyboard_setled(void){
/*
    int t;
    
    t = 0;
    if( caps_flag ) t |= 1;
    if( kana_flag ) t |= 2;
    if( ins_flag  ) t |= 4;
    led_val = t;
    led_flag = True;
    */
}

void
do_events(void){
	if( gui_flag ){
		/* dummy wait */
		usleep( 10000 );
		gui_timer();
		snd_guitimer();
		keyboard_timer();	/* to enable key-repeat in common-GUI */
	}
}
