/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 Toshio ISHIZAKA(vh6t-iszk@asahi-net.or.jp)
 *	[ UNIX-like generic file I/O ]
 */

#if defined(_XWIN)

#include <stdio.h>
#include <fcntl.h>
#include <assert.h>
#include "xm7.h"
#include "device.h"

/*
 *	File read
 */
BOOL file_load(char *fname, BYTE *buf, int size)
{
	int handle;

	handle = open(fname, O_RDONLY);
	if (handle == -1) {
		return FALSE;
	}

	if (read(handle, buf, size) != size) {
		close(handle);
		return FALSE;
	}

	close(handle);
	return TRUE;
}

/*
 *	file open
 */
int file_open(char *fname, int mode)
{
	switch (mode) {
		case OPEN_R:
			return open(fname, O_RDONLY);
			break;
		case OPEN_W:
			return open(fname, O_CREAT | O_WRONLY);
			break;
		case OPEN_RW:
			return open(fname, O_RDWR);
			break;
	}

	return -1;
}

/*
 *	file close
 */
void file_close(int handle)
{
	close(handle);
}

/*
 *	get filesize
 */
DWORD file_getsize(int handle)
{
	off_t now;
	off_t end;

	now = lseek( handle, (off_t)0, SEEK_CUR );
	if (now == -1) {
		return 0;
	}

	end = lseek(handle, (off_t)0, SEEK_END);
	lseek(handle, now, SEEK_SET);

	return end;
}

/*
 *	file seek
 */
BOOL file_seek(int handle, DWORD offset)
{
	off_t now;

	now = lseek(handle, (off_t)offset, SEEK_SET);
	if (now != offset) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	file read
 */
BOOL file_read(int handle, BYTE *ptr, DWORD size)
{
	DWORD cnt;

	cnt = (DWORD)read(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	file write
 */
BOOL file_write(int handle, BYTE *ptr, DWORD size)
{
	DWORD cnt;

	cnt = (DWORD)write(handle, ptr, size);
	if (cnt != size) {
		return FALSE;
	}

	return TRUE;
}


#endif	/* _XWIN */
