/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 Toshio ISHIZAKA(vh6t-iszk@asahi-net.or.jp)
 *	[ X window keycode translation ]
 */

#ifdef _XWIN

#include <X11/Xlib.h>
#include <X11/keysymdef.h>
#include "xm7.h"
#include "xw.h"
#include "gui.h"

/*-[ code convertion ]------------------------------------------------------*/

/*
 *	X window keycode -> FM7 physical code
 *	translation table
 */

static unsigned char xwin_key_table[] = {
    0xff, 0xff, 0xff, 0xff, /*   0- : */
    0xff, 0xff, 0xff, 0xff, /*   4- : */
    0xff, 0x5c, 0x02, 0x03, /*   8- : ? ESC->Break [1] [2] */
    0x04, 0x05, 0x06, 0x07, /*  12- : [3] [4] [5] [6] */
    0x08, 0x09, 0x0a, 0x0b, /*  16- : [7] [8] [9] [0] */
    0x0c, 0x0d, 0x0f, 0x10, /*  20- : [-] [^] BS  Tab */
    0x11, 0x12, 0x13, 0x14, /*  24- : [Q] [W] [E] [R] */
    0x15, 0x16, 0x17, 0x18, /*  28- : [T] [Y] [U] [I] */
    0x19, 0x1a, 0x1b, 0x1c, /*  32- : [O] [P] [@]  [  */
    0x1d, 0x55, 0x1e, 0x1f, /*  36- : Enter->Return CapsLock [A] [S] */
    0x20, 0x21, 0x22, 0x23, /*  40- : [D] [F] [G] [H] */
    0x24, 0x25, 0x26, 0x27, /*  44- : [J] [K] [L] [;] */
    0x28, 0x01, 0x53, 0x29, /*  48- : [:] ZenHan->ESC Lsft   ]  */
    0x2a, 0x2b, 0x2c, 0x2d, /*  52- : [Z] [X] [C] [V] */
    0x2e, 0x2f, 0x30, 0x31, /*  56- : [B] [N] [M] [,] */
    0x32, 0x33, 0x54, 0x38, /*  60- : [.] [/]  Rsft  <*>-><+>  */
    0xff, 0x57, 0x52, 0x5d, /*  64- : AltL Space->Lspace Caps F1 */
    0x5e, 0x5f, 0x60, 0x61, /*  68- :  F2  F3  F4  F5 */
    0x62, 0x63, 0x64, 0x65, /*  72- :  F6  F7  F8  F9 */
    0x66, 0x36, 0xff, 0x3a, /*  76- : F10 NumLk-><*> ScrLk <7> */
    0x3b, 0x3c, 0x39, 0x3e, /*  80- : <8> <9> <-> <4> */
    0x3f, 0x40, 0x3d, 0x42, /*  84- : <5> <6> <+>-><=> <1> */
    0x43, 0x44, 0x46, 0x47, /*  88- : <2> <3> <0> <.> */
    0x3f, 0x40, 0xff, 0xff, /*  92- : <5> <6> <?> F11 */
    0xff, 0x49, 0x4d, 0x4a, /*  96- : F12 Home->EL Up PageUp->CLS */
    0x4f, 0xff, 0x51, 0x4c, /* 100- : Left ? Right End->DUP */
    0x50, 0x4e, 0x48, 0x4b, /* 104- : Down PgDn->HOME Ins Del*/
    0x45, 0x5a, 0xff, 0xff, /* 108- : <Ent> RCtrl->KANA Pause PrtSc */
    0xff, 0xff, 0xff, 0xff, /* 112- : ? ? ? Lwin */
    0xff, 0xff, 0xff, 0xff, /* 116- : Rwin Start ? ? */
    0xff, 0x35, 0xff, 0x34, /* 120- : HiraKata->Rspace ? ? [_] */
    0xff, 0xff, 0xff, 0xff, /* 124- : */
    0xff, 0xff, 0xff, 0x56, /* 128- : ? XFER->Cspace ? NFER->GRAPH */
    0xff, 0x0e, 0xff, 0xff, /* 132- : ? [? ? */
};

/*-[ Keyboard ]-------------------------------------------------------------*/

/*
 *	Key Init
 */

void
key_init( void ){
	return;
}

/*
 *	Key Down
 */

void
key_down( int code ){
	int newkey = xwin_key_table[code];
    
	if( newkey != 0xff ){
		keyboard_make( xwin_key_table[code] );
//		printf( "key_down %d\n", code );
    }
	if( code == 95 ){ /* F11 pressed, disk#0 change */
		gui_start();
	}

	if( code == 96 ){ /* F12 pressed, disk#1 change */
		gui_start();
	}
}


/*
 *	Key Up
 */

void
key_up( int code ){
	int newkey = xwin_key_table[code];
    
	if( newkey != 0xff ){
		keyboard_break( xwin_key_table[code] );
//		printf( "key_up   %d\n", code );
	}
}

#endif /* _XWIN */
