/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ PC-98 L[{[h ]
 */

#if defined(__MSDOS__) && defined(PC98)

#include <assert.h>
#include <dos.h>
#include <string.h>
#include "xm7.h"
#include "98.h"
#include "keyboard.h"

/*
 *	X^eBbN [N
 */
static DWORD boot_stopvct;
static DWORD boot_copyvct;
static BYTE boot_kbdbeep;
static BYTE kbd_work[32];

/*
 *	O[o [N
 */
BYTE kbd_map[16];

/*
 *	L[{[hϊe[u
 */
typedef struct {
	BYTE pc98;
	BYTE fm7;
} key_table_t;

const key_table_t key_table[] = {
	{ 0x38, 0x48 },				/* INS */
	{ 0x39, 0x4b },				/* DEL */
	{ 0x3a, 0x4d },				/*  */
	{ 0x3b, 0x4f },				/*  */
	{ 0x3c, 0x51 },				/*  */
	{ 0x3d, 0x50 },				/*  */

	{ 0x3e, 0x36 },				/* HOME CLR */
	{ 0x3f, 0x37 },				/* HELP */
	{ 0x40, 0x38 },				/* - */
	{ 0x41, 0x39 },				/* / */

	{ 0x42, 0x3a },				/* 7 */
	{ 0x43, 0x3b },				/* 8 */
	{ 0x44, 0x3c },				/* 9 */
	{ 0x45, 0x3d },				/* * */

	{ 0x46, 0x3e },				/* 4 */
	{ 0x47, 0x3f },				/* 5 */
	{ 0x48, 0x40 },				/* 6 */
	{ 0x49, 0x41 },				/* + */

	{ 0x4a, 0x42 },				/* 1 */
	{ 0x4b, 0x43 },				/* 2 */
	{ 0x4c, 0x44 },				/* 3 */

	{ 0x4e, 0x46 },				/* 0 */
	{ 0x50, 0x47 },				/* . */

	{ 0x70, 0x53 },				/* SHIFT */
	{ 0x71, 0x55 },				/* CAPS */
	{ 0x72, 0x5a },				/*  */
	{ 0x73, 0x56 },				/* GRAPH */
	{ 0x74, 0x52 },				/* CTRL */

	{ 0x60, 0x5c },				/* BREAK */
	{ 0x62, 0x5d },				/* f.1 */
	{ 0x63, 0x5e },				/* f.2 */
	{ 0x64, 0x5f },				/* f.3 */
	{ 0x65, 0x60 },				/* f.4 */
	{ 0x66, 0x61 },				/* f.5 */
	{ 0x67, 0x62 },				/* f.6 */

	{ 0x68, 0x63 },				/* f.7 */
	{ 0x69, 0x64 },				/* f.8 */
	{ 0x6a, 0x65 },				/* f.9 */
	{ 0x6b, 0x66 }				/* f.10 */
};

/*
 *	STOP,COPYL[荞
 */
void interrupt kbd_stopcopy(void)
{
}

/*
 *	L[{[h 
 */
void kbd_init(void)
{
	BYTE *p;

	/* L[{[hBEEP~߂ */
	p = (BYTE far *)0x00000500;
	boot_kbdbeep = *p & 0x20;
	*p |= 0x20;

	/* [N */
	memset(kbd_work, 0, sizeof(kbd_work));
	memset(kbd_map, 0, sizeof(kbd_map));

	/* STOP,COPY荞 */
	disable();
	boot_stopvct = *(DWORD far *)0x00000014;
	boot_copyvct = *(DWORD far *)0x00000018;
	*(DWORD far *)0x00000014 = (DWORD)kbd_stopcopy;
	*(DWORD far *)0x00000018 = (DWORD)kbd_stopcopy;
	enable();
}

/*
 *	L[{[h N[Abv
 */
void kbd_cleanup(void)
{
	BYTE *p;
	BYTE dat;
	union REGS regs;

	/* STOP,COPY荞 */
	disable();
	*(DWORD far *)0x00000014 = boot_stopvct;
	*(DWORD far *)0x00000018 = boot_stopvct;
	enable();

	/* L[{[hBEEP߂ */
	p = (BYTE far *)0x00000500;
	dat = *p;
	dat &= ~0x20;
	dat |= boot_kbdbeep;
	*p = dat;

	/* L[{[hǂݎ̂Ă */
	for (;;) {
		/* L[obt@`FbN */
		regs.h.ah = 0x01;
		int86(0x18, &regs, &regs);
		if (regs.h.bh == 0) {
			break;
		}

		/* P擾 */
		regs.h.ah = 0x00;
		int86(0x18, &regs, &regs);
	}
}

/*
 *	L[R[hϊ
 *	PC98  FM7
 */
BYTE pc98_to_fm7(BYTE pc98)
{
	int i;

	/* ESCSPACE܂ł́APC98+1 = FM7 */
	if (pc98 <= 0x34) {
		return pc98 + 1;
	}

	/* L[ϊe[u */
	for (i=0; i< sizeof(key_table)/sizeof(key_table_t); i++) {
		if (key_table[i].pc98 == pc98) {
			return key_table[i].fm7;
		}
	}

	return 0;
}

/*
 *	^C}荞
 *	L[{[h
 */
void kbd_timer(void)
{
	BYTE *p;
	int i;
	int j;
	BYTE bit;
	BYTE dat;
	BYTE code;
	int count;

	/* f[^擾 */
	p = (BYTE far *)0x0000052a;
	for (i=0; i<16; i++) {
		kbd_work[i] = *p++;
	}

	/* ȑÕf[^or */
	for (i=0; i<16; i++) {
		kbd_work[i] |= kbd_work[i + 16];
	}

	/* kbd_mapxor,ω_𓾂 */
	for (i=0; i<16; i++) {
		kbd_map[i] ^= kbd_work[i];
	}

	/* ω_`FbNAKvłmake / breako */
	count = 0;
	for (i=0; i<16; i++) {
		bit = 0x01;
		dat = kbd_map[i];
		for (j=0; j<8; j++) {
			if (dat & bit) {
				/* ω_ */
				code = pc98_to_fm7(count);
				if (code != 0) {
					if (kbd_work[i] & bit) {
						keyboard_make(code);
					}
					else {
						/* CAPKANABreakłȂMakeo */
						if ((code == 0x55) || (code == 0x5a)) {
							keyboard_make(code);
						} else {
							keyboard_break(code);
						}
					}
				}
			}
			count++;
			bit += bit;
		}
	}

	/* kbd_mapXV */
	for (i=0; i<16; i++) {
		kbd_map[i] = kbd_work[i];
	}

	/* ēxAf[^擾 */
	p = (BYTE far *)0x0000052a;
	for (i=0; i<16; i++) {
		kbd_work[i + 16] = *p++;
	}

	/*
	 *	PC-98L[̈v(FM77AV XL[h͕sv)
	 */

	/* CAPŠ */
	if (kbd_map[0x0e] & 0x02) {
		if (!caps_flag) {
			keyboard_make(0x55);
		}
	}
	if (!(kbd_map[0x0e] & 0x02)) {
		if (caps_flag) {
			keyboard_make(0x55);
		}
	}

	/* Jǐ */
	if (kbd_map[0x0e] & 0x04) {
		if (!kana_flag) {
			keyboard_make(0X5a);
		}
	}
	if (!(kbd_map[0x0e] & 0x04)) {
		if (kana_flag) {
			keyboard_make(0X5a);
		}
	}
}

#endif	/* __MSDOS__  && PC98 */
