/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ FMjbgڑ ]
 */

#ifndef _cisc_h_
#define _cisc_h_

#include <math.h>

#ifdef __MSDOS__
typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned long uint32;
typedef signed char sint8;
typedef signed short sint16;
typedef signed long sint32;
typedef signed char int8;
typedef signed short int16;
typedef signed long int32;
#else
typedef unsigned char uchar;
typedef unsigned short ushort;
typedef unsigned int uint;
typedef unsigned long ulong;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef unsigned int  uint32;
typedef signed char sint8;
typedef signed short sint16;
typedef signed int sint32;
typedef signed char int8;
typedef signed short int16;
typedef signed int int32;
#endif

#define LOG0(a)				((void)0)
#define LOG1(a,b)			((void)0)
#define LOG2(a,b,c)			((void)0)
#define LOG3(a,b,c,d)		((void)0)

#if defined(_WIN32) || defined(__MSDOS__)
typedef int bool;
#define false	0
#define true	(!false)
#endif

inline int32 Max(int32 x, int32 y)
{
	return (x > y) ? x : y;
}

inline int32 Min(int32 x, int32 y)
{
	return (x < y) ? x : y;
}

inline int32 Limit(int32 v, int32 max, int32 min)
{ 
	return v > max ? max : (v < min ? min : v); 
}

#endif	/* _cisc_h_ */
