/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ foCXˑ ]
 */

#ifndef _device_h_
#define _device_h_

/*
 *	萔`
 */
#define OPEN_R		1
#define OPEN_W		2
#define OPEN_RW		3

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */
void do_events(void);
										/* Cxg */

/* ` */
void vram_setb(WORD addr, BYTE dat);
										/* VRAM */
void ttlpalet_setb(int no, BYTE dat);
										/* pbg */
void vramoff_setw(WORD offset);
										/* VRAMItZbgWX^ */

/* L[{[h */
void keyboard_setled(void);
										/* L[{[hLED */

/* AWCXeBbN */
void opn_setb(BYTE reg, BYTE dat);
										/* OPNo */
BYTE joy_getb(BYTE port);
										/* WCXeBbN */

/* t@C */
BOOL file_load(char *fname, BYTE *buf, int size);
										/* t@C[h */
int file_open(char *fname, int mode);
										/* t@CI[v */
void file_close(int handle);
										/* t@CN[Y */
DWORD file_getsize(int handle);
										/* t@COX擾 */
BOOL file_seek(int handle, DWORD offset);
										/* t@CV[N */
BOOL file_read(int handle, BYTE *ptr, DWORD size);
										/* t@Cǂݍ */
BOOL file_write(int handle, BYTE *ptr, DWORD size);
										/* t@C */

/* t@CTu(vbgtH[ˑB̂system.cɂ) */
BOOL file_byte_read(int handle, BYTE *dat);
										/* oCgǂݍ */
BOOL file_word_read(int handle, WORD *dat);
										/* [hǂݍ */
BOOL file_dword_read(int handle, DWORD *dat);
										/* _u[hǂݍ */
BOOL file_bool_read(int handle, BOOL *dat);
										/* u[ǂݍ */
BOOL file_byte_write(int handle, BYTE dat);
										/* oCg */
BOOL file_word_write(int handle, WORD dat);
										/* [h */
BOOL file_dword_write(int handle, DWORD dat);
										/* _u[h */
BOOL file_bool_write(int handle, BOOL dat);
										/* u[ */
#ifdef __cplusplus
}
#endif

#endif	/* _device_h_ */
