/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ tbs[fBXN Rg[(MB8877A) ]
 */

#ifndef _fdc_h_
#define _fdc_h_

/*
 *	萔`
 */
#define FDC_DRIVES			4			/* T|[ghCu */
#define FDC_MEDIAS			16			/* D77t@CɊ܂܂ő喇 */

#define FDC_ST_BUSY			0x01
#define FDC_ST_INDEX		0x02
#define FDC_ST_DRQ			0x02
#define FDC_ST_TRACK00		0x04
#define FDC_ST_LOSTDATA		0x04
#define FDC_ST_CRCERR		0x08
#define FDC_ST_SEEKERR		0x10
#define FDC_ST_RECNFND		0x10
#define FDC_ST_HEADENG		0x20
#define FDC_ST_RECTYPE		0x20
#define FDC_ST_WRITEFAULT	0x20
#define FDC_ST_WRITEP		0x40
#define FDC_ST_NOTREADY		0x80

#define FDC_TYPE_NOTREADY	0
#define FDC_TYPE_2D			1
#define FDC_TYPE_D77		2

#define FDC_ACCESS_READY	0
#define FDC_ACCESS_SEEK		1
#define FDC_ACCESS_READ		2
#define FDC_ACCESS_WRITE	3

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */
BOOL fdc_init(void);
										/*  */
void fdc_cleanup(void);
										/* N[Abv */
void fdc_reset(void);
										/* Zbg */
BOOL fdc_readb(WORD addr, BYTE *dat);
										/* ǂݏo */
BOOL fdc_writeb(WORD addr, BYTE dat);
										/*  */
BOOL fdc_save(int fileh);
										/* Z[u */
BOOL fdc_load(int fileh, int ver);
										/* [h */
int fdc_setdisk(int drive, char *fname);
										/* fBXNZbg */
BOOL fdc_setmedia(int drive, int index);
										/* fBXNt@CfBAw */
BOOL fdc_setwritep(int drive, BOOL writep);
										/* CgveNgw */

/*
 *	v[N
 */
extern BYTE fdc_command;
										/* $FD18 FDCR}h */
extern BYTE fdc_status;
										/* $FD18 FDCXe[^X */
extern BYTE fdc_trkreg;
										/* $FD19 gbNWX^ */
extern BYTE fdc_secreg;	
										/* $FD1A ZN^WX^ */
extern BYTE fdc_datareg;
										/* $FD1B f[^WX^ */
extern BYTE fdc_sidereg;
										/* $FD1C TChWX^ */
extern BYTE fdc_motor;
										/* $FD1D [^(on:0x80 off:0x00) */
extern BYTE fdc_drvreg;
										/* $FD1D hCu(0-3) */
extern BYTE fdc_drqirq;
										/* $FD1E DRQ, IRQ */

extern BYTE fdc_cmdtype;
										/* R}h^Cv */
extern WORD fdc_totalcnt;
										/* g[^JE^ */
extern WORD fdc_nowcnt;
										/* JgJE^ */
extern BYTE fdc_ready[FDC_DRIVES];
										/* fB */
extern BOOL fdc_writep[FDC_DRIVES];
										/* ݋֎~ */
extern BYTE fdc_track[FDC_DRIVES];
										/* gbN */

extern char fdc_fname[FDC_DRIVES][128+1];
										/* t@Cl[ */
extern BOOL fdc_fwritep[FDC_DRIVES];
										/* ݋֎~(t@CP) */
extern BYTE fdc_header[FDC_DRIVES][0x2b0];
										/* D77t@Cwb_ */
extern char fdc_name[FDC_DRIVES][FDC_MEDIAS][17];
										/* fBAƂ̖O */
extern BYTE fdc_medias[FDC_DRIVES];
										/* fBA */
extern BYTE fdc_media[FDC_DRIVES];
										/* fBAZNg */
extern BYTE fdc_access[FDC_DRIVES];
										/* ANZXLED */
#ifdef __cplusplus
}
#endif

#endif	/* _fdc_h_ */
